from commons.core.utils.FileUtils import FileUtils
from commons.core.sql.DbFactory import DbFactory
from commons.pyRepetUnit.convCoord.ConvPathChr2Chunk import ConvPathChr2Chunk
import unittest
import os

class Test_ConvPathChr2Chunk(unittest.TestCase):

    def setUp(self):
        self._pathfilename="dummy.path"
        self._pathtablename="dummy_path"
        
        self._chunkmapfilename="chunk.map"
        self._chunkmaptable="test_chunk_map"
        
        self._resfilename="dummy_res.path"
        
        map4convData="chunk1\tchr1\t1\t100\n"
        map4convData+="chunk2\tchr1\t90\t200\n"
        map4convData+="chunk3\tchr1\t190\t300\n"

        map4conv=open(self._chunkmapfilename,"w")
        map4conv.write(map4convData)
        map4conv.close()
        
        self._db = DbFactory.createInstance()
        self._db.createTable(self._chunkmaptable, "map", self._chunkmapfilename, True)
        
        path2convData="1\tchr1\t10\t80\tsub1\t10\t50\t0.01\t1000\t99\n"
        path2convData+="1\tchr1\t90\t110\tsub1\t10\t50\t0.01\t1000\t99\n"
        path2convData+="2\tchr1\t150\t160\tsub1\t10\t50\t0.01\t1000\t99\n"
        
        path2convData+="3\tchr1\t70\t210\tsub1\t10\t50\t0.01\t1000\t99\n"
        path2convData+="4\tchr1\t85\t100\tsub1\t10\t50\t0.01\t1000\t99\n"
        path2convData+="5\tchr1\t85\t110\tsub1\t10\t50\t0.01\t1000\t99\n"
        
        path2convData+="6\tchr1\t10\t80\tsub1\t10\t50\t0.01\t1000\t99\n"
        path2convData+="6\tchr1\t90\t110\tsub1\t10\t50\t0.01\t1000\t99\n"
        path2convData+="7\tchr1\t150\t160\tsub1\t10\t50\t0.01\t1000\t99\n"
        path2convData+="8\tchr1\t190\t300\tsub1\t10\t50\t0.01\t1000\t99\n"
        
        path2convData+="9\tchr1\t70\t210\tsub1\t10\t50\t0.01\t1000\t99\n"
        path2convData+="10\tchr1\t85\t100\tsub1\t10\t50\t0.01\t1000\t99\n"
        path2convData+="11\tchr1\t85\t110\tsub1\t10\t50\t0.01\t1000\t99\n"
        path2convData+="12\tchr1\t190\t300\tsub1\t10\t50\t0.01\t1000\t99\n"
                        
        path2conv=open(self._pathfilename,"w")
        path2conv.write(path2convData)
        path2conv.close()
        
        self._db.createTable(self._pathtablename, "path", self._pathfilename)

        pathResData="1\tchunk1\t10\t80\tsub1\t10\t50\t0.01\t1000\t99\n"
        pathResData+="1\tchunk1\t90\t100\tsub1\t10\t50\t0.01\t1000\t99\n"
        pathResData+="1\tchunk2\t1\t21\tsub1\t10\t50\t0.01\t1000\t99\n"
        pathResData+="2\tchunk2\t61\t71\tsub1\t10\t50\t0.01\t1000\t99\n"

        pathResData+="3\tchunk1\t70\t100\tsub1\t10\t50\t0.01\t1000\t99\n"
        pathResData+="3\tchunk2\t1\t111\tsub1\t10\t50\t0.01\t1000\t99\n"
        pathResData+="3\tchunk3\t1\t21\tsub1\t10\t50\t0.01\t1000\t99\n"
        
        pathResData+="4\tchunk1\t85\t100\tsub1\t10\t50\t0.01\t1000\t99\n"
        pathResData+="4\tchunk2\t1\t11\tsub1\t10\t50\t0.01\t1000\t99\n"
        pathResData+="5\tchunk1\t85\t100\tsub1\t10\t50\t0.01\t1000\t99\n"
        pathResData+="5\tchunk2\t1\t21\tsub1\t10\t50\t0.01\t1000\t99\n"
        
        pathResData+="6\tchunk1\t10\t80\tsub1\t10\t50\t0.01\t1000\t99\n"
        pathResData+="6\tchunk1\t90\t100\tsub1\t10\t50\t0.01\t1000\t99\n"
        pathResData+="6\tchunk2\t1\t21\tsub1\t10\t50\t0.01\t1000\t99\n"
        pathResData+="7\tchunk2\t61\t71\tsub1\t10\t50\t0.01\t1000\t99\n"
        pathResData+="8\tchunk2\t101\t111\tsub1\t10\t50\t0.01\t1000\t99\n"
        pathResData+="8\tchunk3\t1\t111\tsub1\t10\t50\t0.01\t1000\t99\n"
        
        pathResData+="9\tchunk1\t70\t100\tsub1\t10\t50\t0.01\t1000\t99\n"
        pathResData+="9\tchunk2\t1\t111\tsub1\t10\t50\t0.01\t1000\t99\n"
        pathResData+="9\tchunk3\t1\t21\tsub1\t10\t50\t0.01\t1000\t99\n"
        
        pathResData+="10\tchunk1\t85\t100\tsub1\t10\t50\t0.01\t1000\t99\n"
        pathResData+="10\tchunk2\t1\t11\tsub1\t10\t50\t0.01\t1000\t99\n"
        pathResData+="11\tchunk1\t85\t100\tsub1\t10\t50\t0.01\t1000\t99\n"
        pathResData+="11\tchunk2\t1\t21\tsub1\t10\t50\t0.01\t1000\t99\n"
        pathResData+="12\tchunk2\t101\t111\tsub1\t10\t50\t0.01\t1000\t99\n"       
        pathResData+="12\tchunk3\t1\t111\tsub1\t10\t50\t0.01\t1000\t99\n"       
                
        pathRes=open(self._resfilename,"w")
        pathRes.write(pathResData)
        pathRes.close()
        
    def tearDown(self):
        self._db.dropTable(self._chunkmaptable)
        self._db.dropTable(self._pathtablename)
        self._db.close()
        os.remove(self._resfilename)
        os.remove(self._pathfilename)
        os.remove(self._chunkmapfilename)

    def test_convert(self):
        conv=ConvPathChr2Chunk(self._db,self._pathtablename, self._chunkmaptable, self._pathtablename+"_onchk")
        conv.convert()
        expPath = self._resfilename
        obsPath = "dummy_path.onchk"
        self._db.exportDataToFile("dummy_path_onchk", obsPath)
        self._db.dropTable("dummy_path_onchk")
        self.assertTrue(FileUtils.are2FilesIdentical(expPath, obsPath))
        os.remove(obsPath)

test_suite = unittest.TestSuite()
test_suite.addTest( unittest.makeSuite( Test_ConvPathChr2Chunk ) )
if __name__ == '__main__':
    unittest.TextTestRunner(verbosity=2).run( test_suite )