from commons.core.utils.FileUtils import FileUtils
from commons.core.seq.BioseqUtils import BioseqUtils

class TranslateInAllFramesAndReplaceStopByX(object):

    def __init__(self):
        self._inputFile = "" 
        self._outputFile =  ""
    
    def setInputFile(self, input):
        self._inputFile = input

    def setOutputFile(self, output):
        self._outputFile = output    
        
    def run(self):
        """
        read a fasta file with nucleotide sequences and translate all sequences in all frames, write the result in a file
        """
        if not FileUtils.isRessourceExists(self._inputFile):
            raise Exception("Warning your input file %s does not exist!\n" % self._inputFile)
        bioseqList = BioseqUtils.extractBioseqListFromFastaFile(self._inputFile)
        bioseqListInAllFrames = BioseqUtils.translateBioseqListInAllFrames(bioseqList)
        bioseqListTranslatedAndStopsReplace = BioseqUtils.replaceStopCodonsByXInBioseqList(bioseqListInAllFrames)
        BioseqUtils.writeBioseqListIntoFastaFile(bioseqListTranslatedAndStopsReplace, self._outputFile)   
                