import os
import unittest
from commons.core.utils.FileUtils import FileUtils

class Test_TranslateAfastaFileInAllFrameAndReplaceStopsByX(unittest.TestCase):
    
    def setUp(self):
        self._inputFile = "dummyInputFile"
        self._outputFile = "dummyOuputFile"
        self._prg = "translateAfastaFileInAllFrameAndReplaceStopsByX_script.py"
        
        
    def testTranslateAfastaFileInAllFrameAndReplaceStopsByX_script(self):
        f = open(self._inputFile, "w")
        f.write(">header1 description\n")
        f.write("TGTGGCTTCTAGTTGATCAGTTTATGATCACAATGATTTCACGTAGGTGTCTCGTGGCTC\n")
        f.write("CGACTAATCAACAATATAATGCGAGTAGAGCTTGA\n")
        f.write(">header2\n")
        f.write("TGTGGCTTCTAGTTGATCAGTTTATGATCACAATGATTTCACGTAGGTGTCTCGTGGCTA\n")
        f.write("CGACTAATCAACAATATAATGCGAGTAGAGCTTGA")
        f.close()
        # expected fasta translated file
        f = open("expectedTranslated.fa", "w")
        f.write(">header1_1 description\n")
        f.write("CGFXLISLXSQXFHVGVSWLRLINNIMRVEL\n")
        f.write(">header1_2 description\n")
        f.write("VASSXSVYDHNDFTXVSRGSDXSTIXCEXSL\n")
        f.write(">header1_3 description\n")
        f.write("WLLVDQFMITMISRRCLVAPTNQQYNASRAX\n")
        f.write(">header1_4 description\n")
        f.write("SSSTRIILLISRSHETPTXNHCDHKLINXKP\n")
        f.write(">header1_5 description\n")
        f.write("QALLALYCXLVGATRHLREIIVIINXSTRSH\n")
        f.write(">header1_6 description\n")
        f.write("KLYSHYIVDXSEPRDTYVKSLXSXTDQLEAT\n")
        f.write(">header2_1\n")
        f.write("CGFXLISLXSQXFHVGVSWLRLINNIMRVEL\n")
        f.write(">header2_2\n")
        f.write("VASSXSVYDHNDFTXVSRGYDXSTIXCEXSL\n")
        f.write(">header2_3\n")
        f.write("WLLVDQFMITMISRRCLVATTNQQYNASRAX\n")
        f.write(">header2_4\n")
        f.write("SSSTRIILLISRSHETPTXNHCDHKLINXKP\n")
        f.write(">header2_5\n")
        f.write("QALLALYCXLVVATRHLREIIVIINXSTRSH\n")
        f.write(">header2_6\n")
        f.write("KLYSHYIVDXSXPRDTYVKSLXSXTDQLEAT\n")
        f.close()
         
        #normal launch
        cmd = self._prg
        cmd += " -i %s" % ( self._inputFile )
        cmd += " -o %s" % ( self._outputFile )
        os.system( cmd )        
        self.assertTrue(FileUtils.are2FilesIdentical( self._outputFile, "expectedTranslated.fa"))
        os.system( "rm " + self._outputFile )
        
        #verbose option
        cmd = self._prg
        cmd += " -i %s" % ( self._inputFile )
        cmd += " -o %s" % ( self._outputFile )
        cmd += " -v 1"
        os.system( cmd )        
        self.assertTrue(FileUtils.are2FilesIdentical( self._outputFile, "expectedTranslated.fa"))
        os.system( "rm " + self._outputFile )
        
        #clean option
        cmd = self._prg
        cmd += " -i %s" % ( self._inputFile )
        cmd += " -o %s" % ( self._outputFile )
        cmd += " -c"
        os.system( cmd )        
        self.assertTrue( FileUtils.are2FilesIdentical( self._outputFile, "expectedTranslated.fa" ) )
        self.assertFalse( FileUtils.isRessourceExists( self._inputFile ) )
        os.system( "rm " + self._outputFile)
        os.system("rm expectedTranslated.fa")
        
        
if __name__ == "__main__":                 
    unittest.main()