import os
from pyRepet.launcher.Launcher import HmmpfamLauncher


class HmmpfamClusterComponent( object ):
    
    def __init__(self):
        self._component = None 
        self._profilDatabank = ""
        self._resultDir = ""
        self._queryDir = ""
        self._tmpDir = ""
        self._jobDb = None
        self._SGEQueue = ""
        self._SGEGroupId = "" 
        
    def loadConfig( self, config ):
        self._profilDatabank = config.get( "profil_search","ProfilDatabank" )
        self._queryDir = config.get( "hmmer_config","query_dir" )
        self._tmpDir = config.get( "hmmer_config", "tmp_dir" )
        self._resultDir = config.get( "hmmer_config", "result_dir" )    
        self._SGEQueue = config.get( "sge_config", "queue" )
        self._SGEGroupId = config.get( "sge_config", "groupid" )
        
    def run(self):
        params = {"param":"--informat FASTA -E 10", 
                  "profilDB": self._profilDatabank, 
                  "outputDir": self._resultDir,
                  "query": self._queryDir,
                  "job_table":"jobs", 
                  "queue" : self._SGEQueue, 
                  "groupid" : self._SGEGroupId,
                  "tmpDir": self._tmpDir,
                  "cDir" : "."}
        self._component = HmmpfamLauncher(self._jobDb, params)
        self._component.run()
        
    def clean (self): 
        dirToClean = self._tmpDir
        os.system("rm  " + dirToClean + "/*")
        dirToClean = self._resultDir
        os.system("rm  " + dirToClean + "/*")
        
    def setProfilDatabank (self, profilDatabank):
        self._profilDatabank = profilDatabank    

    def getProfilDatabank(self):
        return self._profilDatabank    

    def setQueryDir(self, input):
        self._queryDir = input
         
    def getQueryDir( self ):
        return self._queryDir

    def setSubjectDir(self, input):
        self._subjectDir = input
         
    def getSubjectDir( self ):
        return self._subjectDir
    
    def setSGEQueue(self, queue):
        self._SGEQueue = queue
        
    def getSGEQueue( self ):
        return self._SGEQueue
        
    def setSGEGrouId(self, id):
        self._SGEGroupId = id    
    
    def getSGEGroupId( self ):
        return self._SGEGroupId;    
    
    def setTmpDir(self, tmpDir):
        self._tmpDir = tmpDir

    def getTmpDir( self ):
        return self._tmpDir
    
    def setResultDir(self, wkDir):
        self._resultDir = wkDir
        
    def getResultDir(self):
        return self._resultDir
    
    def setJobDb (self, jobDb):
        self._jobDb = jobDb
        
    def getJobDb (self):
        return self._jobDb
     