import os
import unittest
from pyRepet.launcher.programLauncher import *
from pyRepet.util.file.FileUtils import *
import commons.pyRepetUnit.fastaTranslation.allFrames.TranslateInAllFramesAndReplaceStopByX
import commons.pyRepetUnit.hmmer.hmmOutput.HmmpfamOutputProcessing
import ConfigParser 

class LaunchPreProcessHmmpfamPostProcessNotInParallel:

    def __init__( self ): 
          
        #for global analysis
        self._configFile = ""
        self._inputFile = ""
        self._outputFile = ""
        self.fileUtils = FileUtils()
        self._programLauncherInstance = programLauncher()
        #specific to PreProcess
        self.bioseq = Bioseq()
        self.preProcess = commons.pyRepetUnit.fastaTranslation.allFrames.TranslateInAllFramesAndReplaceStopByX.TranslateInAllFramesAndReplaceStopByX()        
        self._outputFilePreprocess =  "" 
        #specific to PostProcess
        self.hmmpfamOutputProcess = commons.pyRepetUnit.hmmer.hmmOutput.HmmpfamOutputProcessing.HmmpfamOutputProcessing()       

    def _cleanTemporaryFiles(self, outputFilePreProcess, outputFileHmmpfam):        
        os.remove( outputFilePreProcess )       
        os.remove( outputFileHmmpfam )       
        
    def _launchPostProcess(self, outputFileHmmpfam):
        return self.hmmpfamOutputProcess.readHmmOutputsAndWriteAlignFile(outputFileHmmpfam, self._outputFile)


    def _launchHmmpfam(self, outputFilePreprocess):
        config = ConfigParser.ConfigParser()
        config.readfp(open(self._configFile))
        self._programLauncherInstance.reset(outputFilePreprocess)
        outputFileHmmpfam = outputFilePreprocess + ".hmmpfamOut"
        self._programLauncherInstance.setOutputFileName(outputFileHmmpfam)
        self._programLauncherInstance.launchHmmpfam(evalFilter=config.get("profil_search", "Evalue"), inputFormat=config.get("profil_search", "InputFormat"), profilDatabank=config.get("profil_search", "ProfilDatabank"))
        return outputFileHmmpfam


    def _launchHmmpfamPreProcess(self):
        self.preProcess.setInputFile(self._inputFile)
        outputFilePreprocess = self._inputFile + ".translated"
        self.preProcess.setOutputFile(outputFilePreprocess)
        self.preProcess.run()
        return outputFilePreprocess
          
    def setInputFile( self, input ):
         self._inputFile = input;

    def setOutputFile( self, output ):
         self._outputFile = output;
            
    def setConfigFile ( self, configFile ):
        self._configFile = configFile
    
    def checkInputFile(self):
        return self._checkFileExitsAndNotEmpty( self._inputFile )
    
    def checkConfigFile(self):
        return self._checkFileExitsAndNotEmpty( self._configFile )
    
    def _checkFileExitsAndNotEmpty(self, fileName):
        fileUtils = FileUtils() 
        if fileUtils.isRessourceExists(fileName) and not fileUtils.isFileEmpty(fileName):
            return 1
        return 0
    
    def run(self):
        
        if not self.checkInputFile():
            print "Warning : there is no input file : " + self._inputFile + "\n"
            return 0        
        if not self.checkConfigFile():
            print "Warning : there is no config file : " + self._configFile + "\n"
            return 0 
        outputFilePreProcess = self._launchHmmpfamPreProcess()    
        outputFileHmmpfam = self._launchHmmpfam(outputFilePreProcess)
        self._launchPostProcess(outputFileHmmpfam)
        self._cleanTemporaryFiles(outputFilePreProcess, outputFileHmmpfam)
        
        
if __name__ == "__main__":                 
    main() 
          
































if __name__ == "__main__":                 
    main() 