import unittest
import re
import os
from commons.pyRepetUnit.hmmer.check.OldDetectFeatureConfigChecker import DetectFeatureConfigChecker
from commons.core.checker.ConfigException import ConfigException

class Test_DetectFeaturesConfigChecker(unittest.TestCase):

    def setUp(self):
        self._detectFeatureConfigChecker = DetectFeatureConfigChecker()

    def testWithDefaultLogger (self):
        lineFound = False
        try:
            self._detectFeatureConfigChecker.check("dummyConfig")
        except ConfigException, e:
            for msg in e.messages:
                if (re.match("CONFIG FILE not found.*", msg)):
                    lineFound = True
        self.assertTrue(lineFound)
        
    def testWithNoConfigFile(self):
        lineFound = False
        try:
            self._detectFeatureConfigChecker.check("dummyConfig")
        except ConfigException, e:
            for msg in e.messages:
                if (re.match("CONFIG FILE not found.*", msg)):
                    lineFound = True
        self.assertTrue(lineFound)

    def testWithNoSectionInConfigFile(self):
        config = open("config.cfg", "w");
        config.close()
        lineFound = False
        try:
            self._detectFeatureConfigChecker.check("config.cfg")
        except ConfigException, e:
            for msg in e.messages:
                if (re.match("\[detect_features\] section not found.*", msg)):
                    lineFound = True
        self.assertTrue(lineFound)
        os.remove("config.cfg")
        
    def testMissingOptionsInConfig (self):
        dict = {}
        MockConfigFile("config.cfg", dict)
        hmmProfilsFound = False
        TE_BLRnFound = False
        try :
            self._detectFeatureConfigChecker.check("config.cfg")
        except ConfigException, e:
            for msg in e.messages:
                if (re.match("\[detect_features\] - No option 'te_hmmer' in section: 'detect_features'", msg)):
                    hmmProfilsFound = True
                if (re.match("\[detect_features\] - No option 'te_blrn' in section: 'detect_features'", msg)):
                    TE_BLRnFound = True
        self.assertTrue(hmmProfilsFound)
        self.assertTrue(TE_BLRnFound)
        os.remove("config.cfg")
   
    def testOptionsIfHmmProfilsSetAtYESInConfig (self):
        
        dict = {
                "TE_HMMER" : "yes", 
                "TE_BLRn" : "no"                
        }
        
        profilDatabankFound = False
        evalueFound = False
        MockConfigFile("config.cfg", dict)
        try :
            self._detectFeatureConfigChecker.check("config.cfg")
        except ConfigException, e:
            for msg in e.messages:
                print msg
                if (re.match("\[detect_features\] - No option 'te_hmm_profiles' in section: 'detect_features' whereas te_hmmer is set", msg)):
                    profilDatabankFound = True   
                if (re.match("\[detect_features\] - No option 'te_hmmer_evalue' in section: 'detect_features' whereas te_hmmer is set - Default value will be set", msg)):
                    evalueFound = True
        self.assertTrue(profilDatabankFound)
        self.assertTrue(evalueFound)
        os.remove("config.cfg")
        
            
    def testOptionsIfHmmProfilsSetAtNOInConfig (self):
        profilDatabankFound = False
        inputFormatFound = False
        evalueFound = False
        dict = {
                "TE_HMMER" : "no"                
        }
        MockConfigFile("config.cfg", dict)
        try :
            self._detectFeatureConfigChecker.check("config.cfg")
        except ConfigException, e:
            for msg in e.messages:
                if (re.match(".+INFO \[detect_features\] - No option 'te_hmm_profiles' in section: 'detect_features' whereas te_hmmer is set", msg)):
                    profilDatabankFound = True   
                if (re.match(".+INFO \[detect_features\] - No option 'te_hmmer_evalue' in section: 'detect_features' whereas te_hmmer is set - Default value will be set", msg)):
                    evalueFound = True
        self.assertFalse(profilDatabankFound)
        self.assertFalse(inputFormatFound)
        self.assertFalse(evalueFound)
        os.remove("config.cfg")
        
    def testTE_BLRnAndTE_hmmerAtNoInConfig (self):
        
        dict = {
                "TE_HMMER" : "no", 
                "TE_BLRn" : "no"                
        }
        
        exceptionNotRaised = True
        MockConfigFile("config.cfg", dict)
        try :
            self._detectFeatureConfigChecker.check("config.cfg")
        except ConfigException:
            exceptionNotRaised = False
        
        self.assertTrue(exceptionNotRaised)
        
        os.remove("config.cfg")
        
class MockConfigFile:
    
    def __init__ (self, fileName, optionsDict):
        
        self._fileName = fileName
        config = open(fileName, "w");
        config.write("[detect_features]\n")
        for key in optionsDict.keys():
            config.write(key + ":" + optionsDict[key] + "\n")
        config.close()


if __name__ == "__main__":
    unittest.main()
