import re
import sys
from parser.mapperParser import *


class PslParser(MapperParser):
  """A class that parses the output of PSL format (of SSAHA and BLAT)"""

  def __init__(self, fileName, verbosity = 0):
    super(PslParser, self).__init__(fileName, verbosity)


  def __del__(self):
    super(PslParser, self).__del__()


  def skipFirstLines(self):
    while "------" not in self.handle.readline():
      pass


  def parseLine(self, line):
    m = re.search(r"^\s*(psl:\s+)?(\d+)\s+(\d+)\s+(\d+)\s+\d+\s+\d+\s+(\d+)\s+\d+\s+(\d+)\s+([+-])\s+(\S+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\S+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\S+)\s+(\S+)\s+(\S+)\s*$", line)
    if m == None:
      sys.exit("Line " + line + " does not have the PSL format")

    mapping = Mapping()

    for i in range(0, int(m.group(16))):
      subMapping = SubMapping()

      subMapping.setSize(int(m.group(17).split(",")[i]))
      subMapping.setDirection(m.group(7))

      subMapping.queryInterval.setName(mapping.queryInterval.name)
      subMapping.queryInterval.setStart(int(m.group(18).split(",")[i]))
      subMapping.queryInterval.setSize(subMapping.size)
      subMapping.queryInterval.setDirection(m.group(7))

      subMapping.targetInterval.setChromosome(mapping.targetInterval.chromosome)
      subMapping.targetInterval.setStart(int(m.group(19).split(",")[i]))
      subMapping.targetInterval.setSize(subMapping.size)
      subMapping.targetInterval.setDirection(1)

      mapping.addSubMapping(subMapping)

    mapping.setSize(int(m.group(2)) + int(m.group(3)) + int(m.group(4)))
    mapping.setNbMismatches(int(m.group(3)) + int(m.group(4)))
    mapping.setNbGaps(int(m.group(5)))
    mapping.setDirection(m.group(7))

    mapping.queryInterval.setName(m.group(8))
    mapping.queryInterval.setSize(int(m.group(9)))
    mapping.queryInterval.setStart(min(int(m.group(10)), int(m.group(11))-1))
    mapping.queryInterval.setEnd(max(int(m.group(10)), int(m.group(11))-1))

    mapping.targetInterval.setChromosome(m.group(12))
    mapping.targetInterval.setSize(int(m.group(13)))
    mapping.targetInterval.setStart(min(int(m.group(14)), int(m.group(15))-1))
    mapping.targetInterval.setEnd(max(int(m.group(14)), int(m.group(15))-1))

    return mapping

