#! /usr/bin/env python
"""Restrict a set of cluster with number of elements"""

import os
from optparse import OptionParser
from parsing.sequenceListParser import *
from structure.transcriptContainer import *
from writer.transcriptWriter import *
from writer.fastaWriter import *
from misc.progress import *
from misc.rPlotter import *


if __name__ == "__main__":
  
  # parse command line
  description = "Restrict Cluster: Select those clusters with a given size. [Category: Personnal]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input",     dest="inputFileName",  action="store",                        type="string", help="input file [compulsory] [format: file in transcript format given by -f]")
  parser.add_option("-f", "--format",    dest="format",         action="store",                        type="string", help="format of the input [compulsory] [format: transcript file format]")
  parser.add_option("-o", "--output",    dest="outputFileName", action="store",                        type="string", help="output file [compulsory] [format: output file in GFF3 format]")
  parser.add_option("-m", "--minSize",   dest="minSize",        action="store",      default=None,     type="int",    help="minimum size [format: int]")
  parser.add_option("-M", "--maxSize",   dest="maxSize",        action="store",      default=None,     type="int",    help="maximum size [format: int]")
  parser.add_option("-y", "--mysql",     dest="mysql",          action="store_true", default=False,                   help="mySQL output [format: bool] [default: false]")
  parser.add_option("-v", "--verbosity", dest="verbosity",      action="store",      default=1,        type="int",    help="trace level [format: int]")
  parser.add_option("-l", "--log",       dest="log",            action="store_true", default=False,                   help="write a log file [format: bool] [default: false]")
  (options, args) = parser.parse_args()

  parser = TranscriptContainer(options.inputFileName, options.format, options.verbosity)
  writer = TranscriptWriter(options.outputFileName, options.format, options.verbosity)
  if options.mysql:
    mySqlWriter = TranscriptWriter(options.outputFileName, "sql", options.verbosity)

  # treat items
  nbItems    = parser.getNbItems()
  progress   = Progress(nbItems, "Analyzing clusters of %s" % (options.inputFileName), options.verbosity)
  nbKept     = 0
  for item in parser.getIterator():
    size = item.getNbExons()
    if (options.minSize == None or options.minSize <= size) and (options.maxSize == None or options.maxSize >= size):
      writer.addElement(item)
      if options.mysql:
        mySqlWriter.addElement(item)
      nbKept += 1
    progress.inc()
  progress.done()
  
  writer.write()
  if options.mysql:
    mySqlWriter.write()

  print "%d items, %d kept (%.2f%%)" % (nbItems, nbKept, float(nbKept) / nbItems * 100)
