import unittest
import os, glob


class Test_F_getReadDistribution(unittest.TestCase):

    def setUp(self):
        self.inputFileName  = "inputFile.fasta"
        self.outputFileName = "outputFile"
         
    def tearDown(self):
        for fileRoot in (self.inputFileName, self.outputFileName):
            for file in glob.glob("%s*" % (fileRoot)):
                os.remove(file)
        os.system("rm .RData")

    def test_run_simple(self):
        handle = open(self.inputFileName, "w")
        handle.write(">test1\n")
        handle.write("AAAAAA\n")
        handle.write(">test2\n")
        handle.write("AAAAAA\n")
        handle.write(">test3\n")
        handle.write("CCCCCC\n")
        handle.close()
        handle.close()
        os.system("python ../getReadDistribution.py -i %s -f fasta -n 1 -o %s -v 0" % (self.inputFileName, self.outputFileName))
        self.assertTrue(os.path.exists("%s.png" % (self.outputFileName)))
        handle = open("%s.txt" % (self.outputFileName))
        lines = handle.readlines()
        self.assertEquals(len(lines), 1)
        self.assertEquals(lines[0], "AAAAAA\t2\n")

        
if __name__ == "__main__":
    unittest.main()

