import unittest
import os, os.path
from optparse import OptionParser
from SMART.Java.Python.misc import Utils
from SMART.Java.Python.clusterize import Clusterize
#TODO: test for n option when option corrected

SMART_PATH = os.environ["REPET_PATH"] + "/SMART"

class Test_F_Clusterize(unittest.TestCase):

    def setUp(self):
        self._inputFileName     = "inputFileTest.bed"
        self._expOutputFileName = "expOutput.gff3"
        self._outputFileName    = "output.gff3"
        self._writeInputFile()
        
    def tearDown(self):
        for file in (self._inputFileName, self._expOutputFileName, self._outputFileName):
            if os.path.exists(file):
                os.remove(file)

    def test_run_2DifferentStrand(self):
        self._writeOutputFile_2DiffStrand(self._expOutputFileName)
        
        args = ["-i", self._inputFileName, "-f", "bed", "-o", self._outputFileName, "-v", "0"]
        parser = OptionParser()
        parser.add_option("-i", "--input",          dest="inputFileName",  action="store",                     type="string", help="input file [compulsory] [format: file in transcript format given by -f]")
        parser.add_option("-f", "--format",         dest="format",         action="store",                     type="string", help="format of file [format: transcript file format]")
        parser.add_option("-o", "--output",         dest="outputFileName", action="store",                     type="string", help="output file [compulsory] [format: output file in GFF3 format]")
        parser.add_option("-c", "--colinear",       dest="colinear",       action="store_true", default=False,                help="merge colinear transcripts only [format: bool] [default: false]")
        parser.add_option("-d", "--distance",       dest="distance",       action="store",      default=0,     type="int",    help="max. distance between two transcripts to be merged [format: int] [default: 0]")
        parser.add_option("-n", "--normalize",      dest="normalize",      action="store_true", default=False,                help="normalize the number of reads per cluster by the number of mappings per read [format: bool] [default: false]")
        parser.add_option("-v", "--verbosity",      dest="verbosity",      action="store",      default=1,     type="int",    help="trace level [format: int] [default: 1]")
        (options, args) = parser.parse_args(args)
        iClusterize = Clusterize(options.verbosity)
        iClusterize.setInputFile(options.inputFileName, options.format)
        iClusterize.setOutputFileName(options.outputFileName)
        iClusterize.setColinear(options.colinear)
        iClusterize.setDistance(options.distance)
        iClusterize.setNormalize(options.normalize)
        iClusterize.run()
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))

    def test_runAsScript_2DifferentStrand(self):
        self._writeOutputFile_2DiffStrand(self._expOutputFileName)
        os.system("python %s/Java/Python/clusterize.py -i %s -f bed -o %s -v 0" % (SMART_PATH, self._inputFileName, self._outputFileName))
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))
        
    def test_runAsScript_2DifferentStrand_map_output(self):
        self._expOutputFileName = "expOutput.map"
        self._outputFileName    = "output.map"
        self._writeOutputFile_2DiffStrandMapFormat(self._expOutputFileName)
        os.system("python %s/Java/Python/clusterize.py -i %s -f bed -o %s -u map -v 0" % (SMART_PATH, self._inputFileName, self._outputFileName))
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))
        
    def test_runAsScript_2SameStrand(self):
        self._writeOutputFile_2SameStrand(self._expOutputFileName)
        os.system("python %s/Java/Python/clusterize.py -i %s -f bed -o %s -c -v 0" % (SMART_PATH, self._inputFileName, self._outputFileName))
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))
    
    def test_runAsScript_distance(self):
        self._writeOutputFile_distance(self._expOutputFileName)
        os.system("python %s/Java/Python/clusterize.py -i %s -f bed -o %s -d 40 -v 0" % (SMART_PATH, self._inputFileName, self._outputFileName))
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))
    
    def _writeInputFile(self):
        f = open(self._inputFileName, "w")
        f.write("arm_X\t10000100\t10000200\ttest1.1\t100\t+\t10000100\t10000200\t0\t1\t100,\t0,\n")
        f.write("arm_X\t10000100\t10000200\ttest1.2\t100\t-\t10000100\t10000200\t0\t1\t100,\t0,\n")
        f.write("arm_2R\t10000100\t10000200\ttest1.3\t100\t+\t10000100\t10000200\t0\t1\t100,\t0,\n")
        f.write("arm_X\t10000000\t10000100\ttest1.4\t100\t+\t10000000\t10000100\t0\t1\t100,\t0,\n")
        f.write("arm_X\t10000200\t10000300\ttest1.5\t100\t+\t10000200\t10000300\t0\t1\t100,\t0,\n")
        f.write("arm_X\t9999900\t9999950\ttest1.6\t100\t+\t9999900\t9999950\t0\t1\t50,\t0,\n")
        f.write("arm_X\t10000000\t10000050\ttest1.7\t100\t-\t10000000\t10000050\t0\t1\t50,\t0,\n")
        f.close()
        
    def _writeOutputFile_2DiffStrand(self, outputFileName):
        f = open(outputFileName, "w")
        f.write("arm_2R\tS-MART\ttranscript\t10000100\t10000199\t.\t+\t.\tID=test1.3;Name=test1.3\n")
        f.write("arm_X\tS-MART\ttranscript\t9999900\t9999949\t.\t+\t.\tID=test1.6;Name=test1.6\n")
        f.write("arm_X\tS-MART\ttranscript\t10000000\t10000099\t.\t-\t.\tnbElements=2.000000;ID=test1.7--test1.4;Name=test1.7--test1.4\n")
        f.write("arm_X\tS-MART\ttranscript\t10000100\t10000199\t.\t-\t.\tnbElements=2.000000;ID=test1.2--test1.1;Name=test1.2--test1.1\n")
        f.write("arm_X\tS-MART\ttranscript\t10000200\t10000299\t.\t+\t.\tID=test1.5;Name=test1.5\n")
        f.close()
        
    def _writeOutputFile_2SameStrand(self, outputFileName):
        f = open(outputFileName, "w")
        f.write("arm_2R\tS-MART\ttranscript\t10000100\t10000199\t.\t+\t.\tID=test1.3;Name=test1.3\n") 
        f.write("arm_X\tS-MART\ttranscript\t9999900\t9999949\t.\t+\t.\tID=test1.6;Name=test1.6\n") 
        f.write("arm_X\tS-MART\ttranscript\t10000000\t10000099\t.\t+\t.\tID=test1.4;Name=test1.4\n") 
        f.write("arm_X\tS-MART\ttranscript\t10000000\t10000049\t.\t-\t.\tID=test1.7;Name=test1.7\n") 
        f.write("arm_X\tS-MART\ttranscript\t10000100\t10000199\t.\t+\t.\tID=test1.1;Name=test1.1\n") 
        f.write("arm_X\tS-MART\ttranscript\t10000100\t10000199\t.\t-\t.\tID=test1.2;Name=test1.2\n") 
        f.write("arm_X\tS-MART\ttranscript\t10000200\t10000299\t.\t+\t.\tID=test1.5;Name=test1.5\n")
        f.close()
        
    def _writeOutputFile_distance(self, outputFileName):
        f = open(outputFileName, "w")
        f.write("arm_2R\tS-MART\ttranscript\t10000100\t10000199\t.\t+\t.\tID=test1.3;Name=test1.3\n")
        f.write("arm_X\tS-MART\ttranscript\t9999900\t9999949\t.\t+\t.\tID=test1.6;Name=test1.6\n")
        f.write("arm_X\tS-MART\ttranscript\t10000000\t10000299\t.\t+\t.\tnbElements=5.000000;ID=test1.5--test1.2--test1.1--test1.7--test1.4;Name=test1.5--test1.2--test1.1--test1.7--test1.4\n")
        f.write("arm_X\tS-MART\texon\t10000000\t10000099\t.\t+\t.\tID=test1.5--test1.2--test1.1--test1.7--test1.4-exon1;Name=test1.5--test1.2--test1.1--test1.7--test1.4-exon1;Parent=test1.5--test1.2--test1.1--test1.7--test1.4\n")
        f.write("arm_X\tS-MART\texon\t10000100\t10000199\t.\t+\t.\tID=test1.5--test1.2--test1.1--test1.7--test1.4-exon2;Name=test1.5--test1.2--test1.1--test1.7--test1.4-exon2;Parent=test1.5--test1.2--test1.1--test1.7--test1.4\n")
        f.write("arm_X\tS-MART\texon\t10000200\t10000299\t.\t+\t.\tID=test1.5--test1.2--test1.1--test1.7--test1.4-exon3;Name=test1.5--test1.2--test1.1--test1.7--test1.4-exon3;Parent=test1.5--test1.2--test1.1--test1.7--test1.4\n")
        f.close()
        
    def _writeOutputFile_2DiffStrandMapFormat(self, outputFileName):
        f = open(outputFileName, "w")
        f.write("test1.3\tarm_2R\t10000100\t10000200\n")
        f.write("test1.6\tarm_X\t9999900\t9999950\n")
        f.write("test1.7--test1.4\tarm_X\t10000000\t10000100\n")
        f.write("test1.2--test1.1\tarm_X\t10000100\t10000200\n")
        f.write("test1.5\tarm_X\t10000200\t10000300\n")
        f.close()
                

if __name__ == "__main__":
    unittest.main()
