import re
import sys
from parser.mapperParser import *


class BlastParser(MapperParser):
  """A class that parses the output of Blast (-m 8 format)"""

  def __init__(self, fileName, verbosity = 0):
    super(BlastParser, self).__init__(fileName, verbosity)


  def __del__(self):
    super(BlastParser, self).__del__()


  def skipFirstLines(self):
    pass


  def parseLine(self, line):
    m = re.search(r"^(\S+)\s+(\S+)\s+(\d+\.?\d*)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+([-+]?\d+\.?\d*[eE]?[-+]?\d*)\s+(\d+\.?\d*)\s*$", line)
    if m == None:
      sys.exit("Line " + line + " does not have the Blast format")

    mapping = Mapping()

    mapping.queryInterval.setName(m.group(1))
    mapping.queryInterval.setStart(min(int(m.group(9)), int(m.group(10))))
    mapping.queryInterval.setEnd(max(int(m.group(9)), int(m.group(10))))

    mapping.targetInterval.setChromosome(m.group(2))
    mapping.targetInterval.setStart(min(int(m.group(7)), int(m.group(8))))
    mapping.targetInterval.setEnd(max(int(m.group(7)), int(m.group(8))))

    mapping.setIdentity(round(float(m.group(3))))
    mapping.setSize(int(m.group(4)))
    mapping.setNbMismatches(int(m.group(5)))
    mapping.setNbGaps(int(m.group(6)))
    mapping.setDirection((int(m.group(8)) - int(m.group(7))) * (int(m.group(10)) - int(m.group(9))))
    mapping.setEvalue(float(m.group(11)))

    return mapping
