from writer.bedWriter import *
from structure.transcript import *


class UcscWriter(BedWriter):
  """
  A class that writes a transcript list into a file with UCSC BED format (minor differences with BED format)
  """


  def __init__(self, fileName, verbosity = 0):
    """
    Constructor
    @param fileName: name of the file 
    @type fileName: string
    @param verbosity: verbosity
    @type verbosity: int
    """
    super(UcscWriter, self).__init__(fileName, verbosity)
    

  def printTranscript(self, transcript):
    """
    Export the given transcript with GBrowse format
    @param transcript: transcript to be printed
    @type transcript: class L{Transcript<Transcript>}
    @return: a string
    """
    return transcript.printUcsc()

