#! /usr/bin/env python
#
# Copyright INRA-URGI 2009-2011
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
from optparse import OptionParser
from SMART.Java.Python.cleaning.CleanerChooser import CleanerChooser


class CleanTranscriptFile(object):

	def __init__(self, verbosity):
		self.verbosity = verbosity
		self.chooser   = CleanerChooser(self.verbosity)

	def setInputFile(self, fileName, format):
		self.chooser.findFormat(format)
		self.cleaner = self.chooser.getCleaner()
		self.cleaner.setInputFileName(fileName)

	def setOutputFile(self, fileName):
		self.cleaner.setOutputFileName(fileName)

	def setAcceptedTypes(self, types):
		if types != None:
			self.cleaner.setAcceptedTypes(types)

	def run(self):
		self.cleaner.clean()


if __name__ == "__main__":

	description = "Clean Transcript File v1.0.1: Clean a transcript file so that it is useable for S-MART. [Category: Other]"

	parser = OptionParser(description = description)
	parser.add_option("-i", "--input",       dest="inputFileName",  action="store",                     type="string", help="query input file [compulsory] [format: file in transcript format given by -f]")
	parser.add_option("-f", "--format",      dest="format",         action="store",                     type="string", help="format of previous file [compulsory] [format: transcript file format]")
	parser.add_option("-t", "--types",       dest="acceptedTypes",  action="store",      default=None,  type="string", help="name of the types you want to keep in GFF/GTF (list separated by commas) [format: string] [default: None]")
	parser.add_option("-o", "--output",      dest="outputFileName", action="store",                     type="string", help="output file [format: output file in GFF3 format]")
	parser.add_option("-v", "--verbosity",   dest="verbosity",      action="store",      default=1,     type="int",    help="trace level [format: int]")
	(options, args) = parser.parse_args()

	ctf = CleanTranscriptFile(options.verbosity)
	ctf.setInputFile(options.inputFileName, options.format)
	ctf.setOutputFile(options.outputFileName)
	ctf.setAcceptedTypes(None if options.acceptedTypes == None else options.acceptedTypes.split(","))
	ctf.run()

