import unittest
import os, glob
import subprocess
from SMART.Java.Python.getSizes import GetSizes

class Test_F_GetSizes(unittest.TestCase):

    def setUp(self):
        self._inputFastaFileName =  "inputFile.fa"
        self._inputFastqFileName =  "inputFile.fq"
         
    def tearDown(self):
        try :
            os.remove(self._inputFastaFileName)
        except:pass
    
    def test_run(self):
        self.writeInputFasta(self._inputFastaFileName)
        format = "fasta"
        iGetSizes = GetSizes(inFileName = self._inputFastaFileName, inFormat=format)
        iGetSizes.run()
        
        self.assertEquals(iGetSizes.items, 3)
        self.assertEquals(iGetSizes.subItems, 3)
        self.assertEquals(iGetSizes.nucleotides, 108)
        self.assertEquals(iGetSizes.minAvgMedMax, (36, 36.0, 36, 36))
    
    def test_run_as_script(self):
        self.writeInputFasta(self._inputFastaFileName)
        format = "fasta"
        cmd = "%s/SMART/Java/Python/getSizes.py -i %s -f %s -v 0" % (os.environ["REPET_PATH"], self._inputFastaFileName, format)
        process = subprocess.Popen(cmd.split(' '), stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        obsOutput = process.communicate()[0]
        expOutput = """3 items\n3 sub-items\n108 nucleotides\nmin/avg/med/max transcripts: 36/36.00/36.0/36\n"""
        
        self.assertEquals(expOutput, obsOutput)
    
    def writeInputFile(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tS-MART\ttest2.1\t9\t1000\t1001\t+\t.\tName=test2.1;overlapsWith=query_3;ID=test2.1\n")
        f.write("chr1\tS-MART\ttest2.3\t100\t600\t501\t+\t.\tName=test2.3;overlapsWith=query_3;ID=test2.3\n")
        f.write("chr1\tS-MART\ttest2.5\t700\t950\t251\t+\t.\tName=test2.5;overlapsWith=query_3;ID=test2.5\n")
        f.write("chr1\tS-MART\ttest2.6\t800\t900\t101\t+\t.\tName=test2.6;overlapsWith=query_3;ID=test2.6\n")
        f.close()     
        
    
    def writeInputFasta(self,inFileName):
        f = open(inFileName,'w')
        f.write('>HWI-EAS337_3:7:1:415:1217/1\n')
        f.write('GATGTGCAGACTTTTCACGCAGGACTACATCACTGT\n')
        f.write('>HWI-EAS337_3:7:1:208:1489/1\n')
        f.write('GGAAACATATGCACATAAACGTTGAAATCATGCTTA\n')
        f.write('>HWI-EAS337_3:7:1:278:1153\n')
        f.write('GAGAAAACCTGTAATAAATACTGAGAGAAAGTAGGG\n')
        f.close()


    def writeInputFastq(self,inFileName):
        f = open(inFileName,'w')
        f.write('@HWI-EAS337_3:7:1:415:1217/1\n')
        f.write('GATGTGCAGACTTTTCACGCAGGACTACATCACTGT\n')
        f.write('+HWI-EAS337_3:7:1:415:1217/1\n')
        f.write('WWWVVVWPWWWVWWWWVVVVKVPWWVVWVWUUQUTQ\n')
        f.write('@HWI-EAS337_3:7:1:208:1489/1\n')
        f.write('GGAAACATATGCACATAAACGTTGAAATCATGCTTA\n')
        f.write('+HWI-EAS337_3:7:1:208:1489/1\n')
        f.write('WWWWWWWWWWWWWWWWWVWWVWWVWWWWWWUUUUUU\n')
        f.write('@HWI-EAS337_3:7:1:278:1153/1\n')
        f.write('GAGAAAACCTGTAATAAATACTGAGAGAAAGTAGGG\n')
        f.write('+HWI-EAS337_3:7:1:278:1153/1\n')
        f.write('WWWWWWWWWWWWWWWWWWWWWWVWVVVWWVUUUUUR\n')
        f.close()
        
            
        
if __name__ == "__main__":
    unittest.main()

