#! /usr/bin/env python
"""Get a given sequence in a multi-Fasta file"""

import os
from optparse import OptionParser
from parsing.sequenceListParser import *
from misc.progress import *


if __name__ == "__main__":
  
  # parse command line
  description = "Get Sequence: Get a single sequence in a FASTA file. [Category: Sequences]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input",     dest="inputFileName",     action="store",                        type="string", help="multi-FASTA file [compulsory] [format: file in FASTA format]")
  parser.add_option("-n", "--name",      dest="name",              action="store",                        type="string", help="name of the sequence [compulsory] [format: string]")
  parser.add_option("-v", "--verbosity", dest="verbosity",         action="store",      default=1,        type="int",    help="trace level [format: int]")
  (options, args) = parser.parse_args()

  # read Fasta file
  sequenceListParser = SequenceListParser(options.inputFileName, options.verbosity)
  for sequence in sequenceListParser.getIterator():
    name = sequence.name.split(" ")[0]
    if name == options.name:
      print sequence.printFasta(),
      sys.exit(0)
  print "No sequence found"
