#!/usr/bin/env python
"""
Converts BAM data to sorted SAM data.
usage: bam_to_sam.py [options]
   --input1: SAM file to be converted
   --output1: output dataset in bam format
"""

import optparse, os, sys, subprocess, tempfile, shutil, tarfile, random
from commons.core.launcher.Launcher import Launcher
from commons.core.sql.TableJobAdaptatorFactory import TableJobAdaptatorFactory
#from galaxy import eggs
#import pkg_resources; pkg_resources.require( "bx-python" )
#from bx.cookbook import doc_optparse
#from galaxy import util

def stop_err( msg ):
    sys.stderr.write( '%s\n' % msg )
    sys.exit()
    
def toTar(tarFileName, samOutputNames):
    dir = os.path.dirname(tarFileName)    
    tfile = tarfile.open(tarFileName + ".tmp.tar", "w")
    currentPath = os.getcwd()
    os.chdir(dir)
    for file in samOutputNames:
        relativeFileName = os.path.basename(file)
        tfile.add(relativeFileName)
    os.system("mv %s %s" % (tarFileName + ".tmp.tar", tarFileName))
    tfile.close()
    os.chdir(currentPath)    
    
def _map(iLauncher, cmd, cmdStart, cmdFinish ):
    lCmds = []
    lCmds.extend(cmd)
    lCmdStart = []
    lCmdStart.extend(cmdStart)
    lCmdFinish = []
    lCmdFinish.extend(cmdFinish)
    return(iLauncher.prepareCommands_withoutIndentation(lCmds, lCmdStart, lCmdFinish))

def _createSamToolsViewCmd(iLauncher, inputFile, tmp_sorted_aligns_file_name, header):
        lArgs = []
        lArgs.append("-o %s" %  inputFile)
        lArgs.append("%s" % tmp_sorted_aligns_file_name)
        if header:
            lArgs.append("-h")
        return iLauncher.getSystemCommand("samtools view", lArgs)

def _createSamToolsSortCmd(iLauncher, inputFile, tmp_sorted_aligns_file_base):
        lArgs = []
        lArgs.append("%s" % inputFile)
        lArgs.append("%s" %  tmp_sorted_aligns_file_base)
        return iLauncher.getSystemCommand("samtools sort", lArgs)

def __main__():
    #Parse Command Line
    parser = optparse.OptionParser()
    parser.add_option('-t', '--tar', dest='outputTar', default=None, help='output all SAM results in a tar file.' )
    parser.add_option( '', '--input1', dest='input1', help='The input list of BAM datasets on txt format.' )
    #parser.add_option( '', '--input1', dest='input1', help='The input BAM dataset' )
    parser.add_option( '', '--output1', dest='output1', help='The output list of SAM datasets on txt format.' )
    #parser.add_option( '', '--output1', dest='output1', help='The output SAM dataset' )
    parser.add_option( '', '--header', dest='header', action='store_true', default=False, help='Write SAM Header' )
    ( options, args ) = parser.parse_args()


    #Parse the input txt file and read a list of BAM files.
    file = open(options.input1, "r")
    lines = file.readlines()
    inputFileNames = []
    samOutputNames = []
    outputName = options.output1
    resDirName = os.path.dirname(outputName) + '/'
    #Write output txt file and define all output sam file names.
    out = open(outputName, "w")
    for line in lines:
        tab = line.split()
        inputFileNames.append(tab[1])
        samOutName = resDirName + tab[0] + '_samOutput_%s.sam' % random.randrange(0, 10000)
        samOutputNames.append(samOutName)
        out.write(tab[0] + '\t' + samOutName  + '\n')
    file.close()
    out.close()

    # output version # of tool
    try:
        tmp_files = []
        tmp = tempfile.NamedTemporaryFile().name
        tmp_files.append(tmp)
        tmp_stdout = open( tmp, 'wb' )
        proc = subprocess.Popen( args='samtools 2>&1', shell=True, stdout=tmp_stdout )
        tmp_stdout.close()
        returncode = proc.wait()
        stdout = None
        for line in open( tmp_stdout.name, 'rb' ):
            if line.lower().find( 'version' ) >= 0:
                stdout = line.strip()
                break
        if stdout:
            sys.stdout.write( 'Samtools %s\n' % stdout )
        else:
            raise Exception
    except:
        sys.stdout.write( 'Could not determine Samtools version\n' )

    tmp_dirs = []
    acronym = "bam_to_sam"
    jobdb = TableJobAdaptatorFactory.createJobInstance()
    iLauncher = Launcher(jobdb, os.getcwd(), "", "", os.getcwd(), os.getcwd(), "jobs", "", acronym, acronym, False, True)
    lCmdsTuples = []
    for i in range(len(inputFileNames)):    #Construct the lines commands
        if os.path.getsize( inputFileNames[i] ) == 0:
            raise Exception, 'Initial input txt file is empty.'
        tmp_dir = tempfile.mkdtemp(dir="%s" % os.getcwd())
        tmp_dirs.append(tmp_dir)
        tmp_sorted_aligns_file = tempfile.NamedTemporaryFile( dir=tmp_dir )
        tmp_sorted_aligns_file_base = tmp_sorted_aligns_file.name
        tmp_sorted_aligns_file_name = '%s.bam' % tmp_sorted_aligns_file.name
        tmp_files.append(tmp_sorted_aligns_file_name)
        tmp_sorted_aligns_file.close()
        
        inputFile = inputFileNames[i]
        outputFile = samOutputNames[i]
        cmd2Launch = []
        cmd2Launch.append(_createSamToolsSortCmd(iLauncher, inputFile, tmp_sorted_aligns_file_base))
        cmd2Launch.append(_createSamToolsViewCmd(iLauncher, outputFile, tmp_sorted_aligns_file_name, options.header))
        cmdStart = []
        cmdFinish = []
        lCmdsTuples.append(_map(iLauncher, cmd2Launch, cmdStart, cmdFinish))    

    iLauncher.runLauncherForMultipleJobs(acronym, lCmdsTuples, True)
    
    if options.outputTar != None:
        toTar(options.outputTar, samOutputNames)       
    #clean up temp files
    for tmp_dir in tmp_dirs:
        if os.path.exists( tmp_dir ):
            shutil.rmtree( tmp_dir )
    #print tmp_files
    #for tmp in tmp_files:
    #    os.remove(tmp)            
    

if __name__=="__main__": __main__()
