import unittest
import os
from commons.core.utils.FileUtils import FileUtils

class Test_F_CrossSsrAndBesMappedByBlatToGff(unittest.TestCase):


    def test_run(self):
        ssrInputFileName = '%s/commons/core/parsing/test/ssrInputFile.tab' % os.environ['REPET_PATH']
        self._writeSsrInputFile(ssrInputFileName)
        blatInputFileName = '%s/commons/core/parsing/test/blatInputFile.tab' % os.environ['REPET_PATH']
        self._writeBlatInputFile(blatInputFileName)
        
        obsOutputFileName = '%s/commons/core/parsing/test/obsOutputFile.tab' % os.environ['REPET_PATH']
        cmd = 'python %s/commons/core/parsing/CrossSsrAndBesMappedByBlatToGff.py -s %s -b %s -o %s' % (os.environ['REPET_PATH'], ssrInputFileName, blatInputFileName, obsOutputFileName)
        os.system(cmd)
        
        expOutputFileName = '%s/commons/core/parsing/test/expOutputFile.tab' % os.environ['REPET_PATH']
        self._writeExpOutputFile(expOutputFileName)
        
        self.assertTrue(FileUtils.are2FilesIdentical(expOutputFileName, obsOutputFileName))
        os.remove(ssrInputFileName)
        os.remove(blatInputFileName)
        os.remove(obsOutputFileName)
        os.remove(expOutputFileName)
    
    def _writeBlatInputFile(self, blatInputFileName):
        file = open(blatInputFileName, 'w')
        file.write('psLayout version 3\n')
        file.write('\n')
        file.write('match    mis-     rep.     N\'s    Q gap    Q gap    T gap    T gap    strand    Q            Q       Q        Q      T            T       T        T      block    blockSizes     qStarts     tStarts\n')
        file.write('         match    match           count    bases    count    bases              name         size    start    end    name         size    start    end    count\n')
        file.write('---------------------------------------------------------------------------------------------------------------------------------------------------------------\n')
        file.write('315\t20\t0\t0\t3\t10\t2\t9\t+\tMRRE1H001H13FM1\t378\t0\t345\tchr16\t22053297\t21686950\t21687294\t4\t76,185,7,67,\t0,77,263,278,\t21686950,21687026,21687213,21687227,\n')
        file.write('690\t11\t0\t0\t1\t3\t2\t4\t-\tmachin1\t704\t0\t704\tchr16\t22053297\t21736364\t21737069\t3\t40,647,14,\t0,43,690,\t21736364,21736406,21737055,\n')
        file.write('554\t26\t0\t0\t1\t16\t1\t17\t-\tMRRE1H032F08FM1\t606\t10\t606\tchr11\t19818926\t3725876\t3726473\t2\t553,27,\t10,579,\t3725876,3726446,\n')
        file.write('620\t23\t0\t0\t0\t0\t0\t0\t-\tmachin2\t643\t0\t643\tchr11\t19818926\t3794984\t3795627\t1\t643,\t0,\t3794984,\n')
        file.write('347\t25\t0\t0\t0\t0\t0\t0\t-\tmachin3\t393\t21\t393\tchr18\t29360087\t12067347\t12067719\t1\t372,\t0,\t12067347,\n')
        file.close()

    def _writeSsrInputFile(self, ssrInputFileName):
        file = open(ssrInputFileName, 'w')
        file.write('BES_name    BES_redundancy    SSR_di/tri/tetranucleotide    SSR_Motif    SSR_Motif_number    SSR_start    SSR_end    BES_size\n')
        file.write('truc1\t1\t4\tttta\t6\t272\t295\t724\n')
        file.write('truc2\t1\t3\taat\t8\t264\t287\t683\n')
        file.write('MRRE1H001H13FM1\t1\t2\tta\t19\t153\t190\t378\n')
        file.write('truc3\t2\t4\taaag\t8\t518\t549\t734\n')
        file.write('MRRE1H032F08FM1\t1\t4\taaat\t7\t544\t571\t606\n')
        file.write('MRRE1H032F08FM1\t2\t2\tag\t10\t587\t606\t606\n')
        file.write('truc4\t1\t2\tat\t16\t519\t550\t672\n')
        file.write('truc5\t1\t3\ttct\t8\t205\t228\t752\n')
        file.write('truc6\t1\t2\tat\t33\t287\t352\t569\n')
        file.close()
        
    def _writeExpOutputFile(self, expOutputFileName):
        file = open(expOutputFileName, 'w')
        file.write('##gff-version 3\n')
        file.write('chr16\tCrossSsrAndBesAlignedByBlat\tSSR\t21687102\t21687139\t.\t+\t.\tID=SSR_MRRE1H001H13FM1_1;Name=SSR_MRRE1H001H13FM1_1;bes_name=MRRE1H001H13FM1;bes_size=378;bes_matchstart=0;bes_matchend=345;bes_redundancy=1;ssr_type=2;ssr_motif=ta;ssr_motif_number=19;ssr_start=153;ssr_end=190;muscadine_seq=tatatatatatatatatatatatatatatatatatata\n')
        file.write('chr11\tCrossSsrAndBesAlignedByBlat\tSSR\t3725930\t3725903\t.\t-\t.\tID=SSR_MRRE1H032F08FM1_1;Name=SSR_MRRE1H032F08FM1_1;bes_name=MRRE1H032F08FM1;bes_size=606;bes_matchstart=10;bes_matchend=606;bes_redundancy=1;ssr_type=4;ssr_motif=aaat;ssr_motif_number=7;ssr_start=544;ssr_end=571;muscadine_seq=aaataaataaataaataaataaataaat\n')
        file.write('chr11\tCrossSsrAndBesAlignedByBlat\tSSR\t3725887\t3725868\t.\t-\t.\tID=SSR_MRRE1H032F08FM1_2;Name=SSR_MRRE1H032F08FM1_2;bes_name=MRRE1H032F08FM1;bes_size=606;bes_matchstart=10;bes_matchend=606;bes_redundancy=2;ssr_type=2;ssr_motif=ag;ssr_motif_number=10;ssr_start=587;ssr_end=606;muscadine_seq=agagagagagagagagagag\n')
        file.close()

if __name__ == "__main__":
    unittest.main()
    
        