import unittest
from commons.core.parsing.BlatFileParser import BlatFileParser


class Test_BlatFileParser(unittest.TestCase):


    def test_parseBlatFile(self):
        fileName = "dummayBlat.psl"
        self._writeBlatInputFile(fileName)
        blatFileParser = BlatFileParser(fileName)
        blatFileParser.parseBlatFile()
        obsNbHits = len(blatFileParser.getListsOfHits())
        self.assertTrue(obsNbHits == 10)
        obsQueries = blatFileParser.getDictOfQueries()
        expQueries = {'5:574_1:574_539_5:1:G/C': 1, '3:574_1:574_539_5:1:G/C': 1, '5:574_2:574_433_5:1:G/C': 1,"3:574_2:574_433_5:1:G/C":1, "5:574_5:574_607_5:1:G/C": 1, "3:574_5:574_607_5:1:G/C": 1}
        self.assertEquals(expQueries, obsQueries)
        
    def test_parseBlatFileByQueries(self):
        fileName = "dummayBlat.psl"
        self._writeBlatInputFile(fileName)
        blatFileParser = BlatFileParser(fileName)
        blatFileParser.parseBlatFileByQueries()
        obsDict = blatFileParser.getDictOfBlatHitsByQueries()
        obs1 = len(obsDict["5:574_1:574_539_5:1:G/C"])
        obs2 = len(obsDict["3:574_1:574_539_5:1:G/C"])
        obs3 = len(obsDict["5:574_2:574_433_5:1:G/C"])
        obs4 = len(obsDict["3:574_2:574_433_5:1:G/C"])
        obs5 = len(obsDict["5:574_5:574_607_5:1:G/C"])
        obs6 = len(obsDict["3:574_5:574_607_5:1:G/C"])
        self.assertTrue(obs1 == 1)
        self.assertTrue(obs2 == 1)
        self.assertTrue(obs3 == 1)
        self.assertTrue(obs4 == 5)
        self.assertTrue(obs5 == 1)
        self.assertTrue(obs6 == 1)
        obsQueries = blatFileParser.getDictOfQueries()
        expQueries = {'5:574_1:574_539_5:1:G/C': 1, '3:574_1:574_539_5:1:G/C': 1, '5:574_2:574_433_5:1:G/C': 1,"3:574_2:574_433_5:1:G/C":1, "5:574_5:574_607_5:1:G/C": 1, "3:574_5:574_607_5:1:G/C": 1}
        self.assertEquals(expQueries, obsQueries)
        
    def _writeBlatInputFile(self, fileName):
        file = open(fileName, "w")
        file.write("psLayout version 3\n")
        file.write("\n")
        file.write("match\tmis- \trep. \tN's\tQ gap\tQ gap\tT gap\tT gap\tstrand\tQ        \tQ   \tQ    \tQ  \tT        \tT   \tT    \tT  \tblock\tblockSizes \tqStarts\t tStarts\n")
        file.write("     \tmatch\tmatch\t   \tcount\tbases\tcount\tbases\t      \tname     \tsize\tstart\tend\tname     \tsize\tstart\tend\tcount\n")
        file.write("---------------------------------------------------------------------------------------------------------------------------------------------------------------\n")
        file.write("246\t0\t0\t4\t0\t0\t0\t0\t-\t5:574_1:574_539_5:1:G/C\t250\t0\t250\ttaecs3B_RPH7\t3109948\t1065213\t1065463\t1\t250,\t0,\t1065213,\n")
        file.write("247\t0\t0\t2\t0\t0\t0\t0\t-\t3:574_1:574_539_5:1:G/C\t250\t1\t250\ttaecs3B_RPH7\t3109948\t1064962\t1065211\t1\t249,\t0,\t1064962,\n")
        file.write("249\t0\t0\t1\t0\t0\t0\t0\t-\t5:574_2:574_433_5:1:G/C\t250\t0\t250\ttaecs3B_RPH7\t3109948\t1065319\t1065569\t1\t250,\t0,\t1065319,\n")
        file.write("245\t0\t0\t5\t0\t0\t0\t0\t-\t3:574_2:574_433_5:1:G/C\t250\t0\t250\ttaecs3B_RPH8\t3109948\t1065068\t1065318\t1\t250,\t0,\t1065068,\n")
        file.write("247\t0\t0\t3\t0\t0\t0\t0\t-\t3:574_2:574_433_5:1:G/C\t250\t0\t250\ttaecs3B_RPH8\t3109948\t1065310\t1065560\t1\t250,\t0,\t1065310,\n")
        file.write("247\t0\t0\t3\t0\t0\t0\t0\t-\t3:574_2:574_433_5:1:G/C\t250\t0\t250\ttaecs3B_RPH9\t3109948\t1065059\t1065309\t1\t250,\t0,\t1065059,\n")
        file.write("247\t0\t0\t3\t0\t0\t0\t0\t-\t3:574_2:574_433_5:1:G/C\t250\t0\t250\ttaecs3B_RPH9\t3109948\t1064805\t1065055\t1\t250,\t0,\t1064805,\n")
        file.write("68\t0\t0\t1\t0\t0\t0\t0\t-\t3:574_2:574_433_5:1:G/C\t69\t0\t69\ttaecs3B_RPH9\t3109948\t1064733\t1064802\t1\t69,\t0,\t1064733,\n")
        file.write("245\t0\t0\t5\t0\t0\t0\t0\t-\t5:574_5:574_607_5:1:G/C\t250\t0\t250\ttaecs3B_RPH9\t3109948\t1065145\t1065395\t1\t250,\t0,\t1065145,\n")
        file.write("247\t0\t0\t3\t0\t0\t0\t0\t-\t3:574_5:574_607_5:1:G/C\t250\t0\t250\ttaecs3B_RPH9\t3109948\t1064894\t1065144\t1\t250,\t0,\t1064894,\n")
        file.close()

if __name__ == "__main__":
    unittest.main()