/**
 *
 * Copyright INRA-URGI 2009-2010
 * 
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software. You can use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 * 
 * As a counterpart to the access to the source code and rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty and the software's author, the holder of the
 * economic rights, and the successive licensors have only limited
 * liability.
 * 
 * In this respect, the user's attention is drawn to the risks associated
 * with loading, using, modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean that it is complicated to manipulate, and that also
 * therefore means that it is reserved for developers and experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or
 * data to be ensured and, more generally, to use and operate it in the
 * same conditions as regards security.
 * 
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */
import java.util.*;

public class FormatsContainer {

  HashMap < String, FormatType > formatTypes;


  public FormatsContainer() {
    this.formatTypes = new HashMap < String, FormatType > ();
  }


  public void addFormat(String type, String format) {
    FormatType formatType;
    if (formatTypes.containsKey(type)) {
      formatType = this.formatTypes.get(type);
    }
    else {
      formatType = new FormatType(type);
      this.formatTypes.put(type, formatType);
    }
    formatType.addFormat(format);
  }


  public Vector < String > getFormatTypes () {
    Vector < String > v = new Vector < String > ();
    v.addAll(this.formatTypes.keySet());
    return v;
  }


  public FormatType getFormats (String type) {
    if (! formatTypes.containsKey(type)) {
      System.out.print("Format type " + type + " is unavailable. Got: ");
      Iterator it = formatTypes.entrySet().iterator();
      while (it.hasNext()) {
        Map.Entry pairs = (Map.Entry) it.next();
        System.out.print(pairs.getKey() + " ");
      }
      System.out.println();
    }
    return formatTypes.get(type);
  }


  public String getFormatType (String format) {
    for (Iterator it = formatTypes.keySet().iterator(); it.hasNext(); ) {
      Object type       =  it.next();
      Object formatType = formatTypes.get(type);
      if (((FormatType) formatType).containsFormat(format)) {
        return (String) type;
      }
    }
    return null;
  }
}


