from structure.transcript import *
from structure.transcriptList import *
from misc.progress import *

class TranscriptListParser(object):
  """A (quite generic) class that reads a list of transcripts"""

  def __init__(self, fileName, verbosity = 0):
    self.verbosity         = verbosity
    self.fileName          = fileName
    self.nbTranscripts     = None
    self.size              = None
    self.chromosomes       = None
    self.currentTranscript = None
    self.currentLineNb     = 0
    try:
      self.handle = open(self.fileName)
    except IOError:
      sys.exit("Error! Transcript file '%s' does not exist! Exiting..." % (self.fileName))
    self.skipFirstLines()


  def __del__(self):
    if not self.handle.close:
      self.handle.close()
    

  def getFileFormats():
    pass
  getFileFormats = staticmethod(getFileFormats)


  def close(self):
    self.handle.close()


  def reset(self):
    self.handle.seek(0)
    self.skipFirstLines()
    self.currentTranscript = None
    self.currentLineNb     = 0
        
    
  def parse(self):
    transcriptList = TranscriptList()
    progress = Progress(self.getNbTranscripts(), "Reading %s" % (self.fileName), self.verbosity)
    for line in self.handle:
      self.currentLineNb += 1
      transcript          = self.parseLine(line)
      transcriptList.addTranscript(transcript)
      progress.inc()
    progress.done()
    return transcriptList


  def getIterator(self):
    self.reset()

    for line in self.handle:
      self.currentLineNb += 1
      transcript          = self.parseLine(line)
      if transcript != None:
        yield transcript
    if self.currentTranscript != None:
      yield self.currentTranscript


  def getInfos(self):
    self.chromosomes   = set()
    self.nbTranscripts = 0
    self.size          = 0
    self.reset()
    if self.verbosity >= 10:
      print "Getting information on %s." % (self.fileName)
    for transcript in self.getIterator():
      self.chromosomes.add(transcript.chromosome)
      self.nbTranscripts += 1
      self.size          += transcript.getSize()
      if self.verbosity >= 10 and self.nbTranscripts % 100000 == 0:
        sys.stdout.write("  %d transcripts read\r" % (self.nbTranscripts))
        sys.stdout.flush()
    self.reset()
    if self.verbosity >= 10:
      print "  %d transcripts read" % (self.nbTranscripts)
      print "Done."

  
  def getNbTranscripts(self):
    if self.nbTranscripts != None:
      return self.nbTranscripts
    self.getInfos()
    return self.nbTranscripts


  def getNbItems(self):
    return self.getNbTranscripts()


  def getChromosomes(self):
    if self.chromosomes != None:
      return self.chromosomes
    self.getInfos()
    return self.chromosomes
  
  
  def getSize(self):
    if self.size != None:
      return self.size
    self.getInfos()
    return self.size
  
  
  def getNbNucleotides(self):
    return self.getSize()


  def setDefaultTagValue(self, name, value):
    for transcript in self.getIterator():
      transcript.setTag(name, value)
