import unittest
import os
from commons.core.parsing.PathNum2Id import PathNum2Id
from commons.core.utils.FileUtils import FileUtils


class Test_PathNum2Id(unittest.TestCase):

    def setUp(self):
        self._inputFileName = "dummyInputPathFile.path"
        self._outputFileName = "dummyOutputPathFile.path"
        self._expectedFileName = "expectedpathFile.path"
        self._pathNum2Id = PathNum2Id()

    def tearDown(self):
        os.remove( self._inputFileName )
        os.remove( self._outputFileName )
        os.remove( self._expectedFileName )

    def test_RunWhithoutReturnAtEndOfFile(self):
        self._createAndFillInputFileWhithoutReturnAtTheEnd()
        self._createExpectedFile()
        self._pathNum2Id.setInFileName( self._inputFileName )
        self._pathNum2Id.setOutFileName( self._outputFileName )
        self._pathNum2Id.run()
        fileutils = FileUtils()
        self.assertTrue(fileutils.are2FilesIdentical(self._outputFileName, self._expectedFileName))
      
    def test_RunWhithReturnAtEndOfFile(self):
        self._createAndFillInputFileWhithReturnAtTheEnd()
        self._createExpectedFile()
        self._pathNum2Id.setInFileName( self._inputFileName )
        self._pathNum2Id.setOutFileName( self._outputFileName )
        self._pathNum2Id.run()
        fileutils = FileUtils()
        self.assertTrue(fileutils.are2FilesIdentical(self._outputFileName, self._expectedFileName))
        
    def _createExpectedFile(self):
        f = open(self._expectedFileName, "w")
        f.write("1\tblumeria_Grouper_590_20:NoCat_1\t91\t108\tDUF234\t5\t22\t1.5\t3.2\t0\n")
        f.write("2\tblumeria_Grouper_590_20:NoCat_1\t111\t119\tDUF1414\t1\t9\t6.3\t2.9\t0\n")
        f.write("3\tblumeria_Grouper_590_20:NoCat_3\t30\t37\tCPW_WPC\t1\t9\t7.7\t1.5\t0\n")
        f.write("4\tblumeria_Grouper_590_20:NoCat_3\t55\t69\tHECT\t341\t355\t9.2e-06\t0.0\t0\n")
        f.write("5\tblumeria_Grouper_590_20:NoCat_4\t82\t91\tDUF46\t173\t182\t0.11\t6.4\t0\n")
        f.write("6\tblumeria_Grouper_590_20:NoCat_5\t121\t125\tPOC4\t276\t280\t6.3\t-1.7\t0\n")
        f.close()

    def _createAndFillInputFileWhithoutReturnAtTheEnd(self):
        f = open(self._inputFileName, "w")
        f.write("1\tblumeria_Grouper_590_20:NoCat_1\t91\t108\tDUF234\t5\t22\t1.5\t3.2\t0\n")
        f.write("2\tblumeria_Grouper_590_20:NoCat_1\t111\t119\tDUF1414\t1\t9\t6.3\t2.9\t0\n")
        f.write("3\tblumeria_Grouper_590_20:NoCat_3\t30\t37\tCPW_WPC\t1\t9\t7.7\t1.5\t0\n")
        f.write("1\tblumeria_Grouper_590_20:NoCat_3\t55\t69\tHECT\t341\t355\t9.2e-06\t0.0\t0\n")
        f.write("2\tblumeria_Grouper_590_20:NoCat_4\t82\t91\tDUF46\t173\t182\t0.11\t6.4\t0\n")
        f.write("3\tblumeria_Grouper_590_20:NoCat_5\t121\t125\tPOC4\t276\t280\t6.3\t-1.7\t0")
        f.close()
        
    def _createAndFillInputFileWhithReturnAtTheEnd(self):
        f = open(self._inputFileName, "w")
        f.write("1\tblumeria_Grouper_590_20:NoCat_1\t91\t108\tDUF234\t5\t22\t1.5\t3.2\t0\n")
        f.write("2\tblumeria_Grouper_590_20:NoCat_1\t111\t119\tDUF1414\t1\t9\t6.3\t2.9\t0\n")
        f.write("3\tblumeria_Grouper_590_20:NoCat_3\t30\t37\tCPW_WPC\t1\t9\t7.7\t1.5\t0\n")
        f.write("1\tblumeria_Grouper_590_20:NoCat_3\t55\t69\tHECT\t341\t355\t9.2e-06\t0.0\t0\n")
        f.write("2\tblumeria_Grouper_590_20:NoCat_4\t82\t91\tDUF46\t173\t182\t0.11\t6.4\t0\n")
        f.write("3\tblumeria_Grouper_590_20:NoCat_5\t121\t125\tPOC4\t276\t280\t6.3\t-1.7\t0\n")
        f.close()

if __name__ == "__main__":
    unittest.main()