from commons.core.parsing.BowtieParser import BowtieParser
import unittest, os


class Test_BlatParser(unittest.TestCase):


    def test_simple(self):
        fileName = "tmpFile.bowtie"
        handle   = open(fileName, "w")
        handle.write("HWI-EAS179_0053:2:1:1365:7879#0/2\t+\tchrXHet\t191698\tACCGCTGAACCACTTTCATNCNTGGGATTGTGAACTGAAACTGTTCACATGAACTTGGAATTCCCAGTAAGTGTGA\tLcaYcacLaTdd`dacacYBaBTa^^TL^M`]`^aa`Tca`LaLTUa]a_bcLcTMMMMa^a^`bT`ccT_UbM_B\t0\t19:G>N,21:T>N\n")
        handle.write("HWI-EAS179_0053:2:1:1365:7879#0/1\t-\tchrXHet\t191803\tCCCCTTGTACACACCGCCCGTCGCTACTACCGATTGAATTATGTAGTGAGGTCTCCGGACGTGATCACTGTGACGC\tBBBBBBBBB`O`DS]]aYabaaa[ULYLY]^b`^a^aZZZ_LLLca_a_b^^aYdbd``d^ccaY`_caccc^acc\t0\t33:T>G,72:T>C\n")
        handle.write("HWI-EAS179_0053:2:1:1371:11420#0/2\t+\tchr3L\t16569206\tTATGAGCGCCAATTTTGCANTTTTATTTTTGTACAAGCCAAGGGTTTTGCAACATTCACAGCGCTTGCCACTTGTC\tcY^bcYLcaL]`]]`aaTaBaab^_ZZ__R[`[cYccc^Ybb^_L`L`Y`aM_a_TcTcc`LL]]MYaYabbTY`^\t0\t19:G>N\n")
        handle.write("HWI-EAS179_0053:2:1:1371:11420#0/1\t-\tchr3L\t16569298\tAATGAACCATTGTAATTACCCACAACACATACAGTCACACACGAGATGCACACAAGTCGGAAACGGAAGCGAGACG\tBBBBBBBBBBBBBBBBBBBBBB^T`]Y^`KZY__LY_a]^T^ccYaYY__YT]VZbL]`b^cLT^a^caccYbT^b\t0\n")
        handle.close()

        parser = BowtieParser("tmpFile.bowtie", 0)
        for cpt, mapping in enumerate(parser.getIterator()):
            transcript = mapping.getTranscript()
            if cpt == 0:
                self.assertEquals(transcript.getName(), "HWI-EAS179_0053:2:1:1365:7879#0/2")
                self.assertEquals(transcript.getChromosome(), "chrXHet")
                self.assertEquals(transcript.getDirection(), 1)
                self.assertEquals(transcript.getStart(), 191699)
                self.assertEquals(transcript.getEnd(), 191774)
                self.assertEquals(transcript.getTagValue("nbMismatches"), 2)
            elif cpt == 1:
                self.assertEquals(transcript.getName(), "HWI-EAS179_0053:2:1:1365:7879#0/1")
                self.assertEquals(transcript.getChromosome(), "chrXHet")
                self.assertEquals(transcript.getDirection(), -1)
                self.assertEquals(transcript.getStart(), 191804)
                self.assertEquals(transcript.getEnd(), 191879)
                self.assertEquals(transcript.getTagValue("nbMismatches"), 2)
            elif cpt == 2:
                self.assertEquals(transcript.getName(), "HWI-EAS179_0053:2:1:1371:11420#0/2")
                self.assertEquals(transcript.getChromosome(), "chr3L")
                self.assertEquals(transcript.getDirection(), 1)
                self.assertEquals(transcript.getStart(), 16569207)
                self.assertEquals(transcript.getEnd(), 16569282)
                self.assertEquals(transcript.getTagValue("nbMismatches"), 1)
            elif cpt == 3:
                self.assertEquals(transcript.getName(), "HWI-EAS179_0053:2:1:1371:11420#0/1")
                self.assertEquals(transcript.getChromosome(), "chr3L")
                self.assertEquals(transcript.getDirection(), -1)
                self.assertEquals(transcript.getStart(), 16569299)
                self.assertEquals(transcript.getEnd(), 16569374)
                self.assertEquals(transcript.getTagValue("nbMismatches"), 0)
            else:
                self.fail()

        os.remove(fileName)
        
        

if __name__ == "__main__":
    unittest.main()

