import unittest
from commons.core.checker.CheckerException import CheckerException
from commons.core.parsing.VarscanHit_v2_2_8_WithTag import VarscanHit_v2_2_8_WithTag
from commons.core.parsing.VarscanHit_WithTag import VarscanHit_WithTag

class Test_VarscanHit_v2_2_8_WithTag(unittest.TestCase):

    def test_setAttributesFromString(self):
        line = "chr1\t1804\tT\tC\t0\t1\t100%\t0\t1\t0\t53\t0.98\t0\t1\t0\t0\t1\t0\tC\tEspeceA\n"
        
        expChrom = "chr1"
        expPosition = "1804"
        expRef = "T"
        expCns = "C"
        expReadsRef = "0"
        expReadsVar = "1"
        expVarFreq = "100%"
        expStrandsRef = "0"
        expStrandsVar = "1"
        expQualRef = "0"
        expQualVar = "53"
        expPValue = "0.98"
        expMapQualRef = "0"
        expMapQualVar = "1"
        expReadsRefPlus = "0"
        expReadsRefMinus = "0"
        expReadsVarPlus = "1"
        expReadsVarMinus = "0"
        expVar = "C"
        expTag = "EspeceA"
        
        varscanHit = VarscanHit_v2_2_8_WithTag()
        varscanHit.setAttributesFromString(line)
        
        obsChrom = varscanHit.getChrom()
        obsPosition = varscanHit.getPosition()
        obsRef = varscanHit.getRef()
        obsCns = varscanHit.getCns()
        obsReadsRef = varscanHit.getReadsRef()
        obsReadsVar = varscanHit.getReadsVar()
        obsVarFreq = varscanHit.getVarFreq()
        obsStrandsRef = varscanHit.getStrandsRef()
        obsStrandsVar = varscanHit.getStrandsVar()
        obsQualRef = varscanHit.getQualRef()
        obsQualVar = varscanHit.getQualVar()
        obsPValue = varscanHit.getPValue()
        obsMapQualRef = varscanHit.getMapQualRef()
        obsMapQualVar = varscanHit.getMapQualVar()
        obsReadsRefPlus = varscanHit.getReadsRefPlus()
        obsReadsRefMinus = varscanHit.getReadsRefMinus()
        obsReadsVarPlus = varscanHit.getReadsVarPlus()
        obsReadsVarMinus = varscanHit.getReadsVarMinus()
        obsVar = varscanHit.getVar()
        obsTag = varscanHit.getTag()
        
        self.assertEquals(expChrom, obsChrom)
        self.assertEquals(expPosition, obsPosition)
        self.assertEquals(expRef, obsRef)
        self.assertEquals(expCns, obsCns)
        self.assertEquals(expReadsRef, obsReadsRef)
        self.assertEquals(expReadsVar, obsReadsVar)
        self.assertEquals(expVarFreq, obsVarFreq)
        self.assertEquals(expStrandsRef, obsStrandsRef)
        self.assertEquals(expStrandsVar, obsStrandsVar)
        self.assertEquals(expQualRef, obsQualRef)
        self.assertEquals(expQualVar, obsQualVar)
        self.assertEquals(expPValue, obsPValue)
        self.assertEquals(expMapQualRef, obsMapQualRef)
        self.assertEquals(expMapQualVar, obsMapQualVar)
        self.assertEquals(expReadsRefPlus, obsReadsRefPlus)
        self.assertEquals(expReadsRefMinus, obsReadsRefMinus)
        self.assertEquals(expReadsVarPlus, obsReadsVarPlus)
        self.assertEquals(expReadsVarMinus, obsReadsVarMinus)
        self.assertEquals(expVar, obsVar)
        self.assertEquals(expTag, obsTag)
        
    def test_setAttributesFromString_empty_chrom(self):
        line = "\t1804\tT\tC\t0\t1\t100%\t0\t1\t0\t53\t0.98\t0\t1\t0\t0\t1\t0\tC\tEspeceA\n"
        varscanHit = VarscanHit_v2_2_8_WithTag()
        try :
            varscanHit.setAttributesFromString(line)
        except CheckerException, e:
            checkerExceptionInstance = e
        expMessage = "The field Chrom is empty in varscan file in line "
        obsMessage = checkerExceptionInstance.msg
        self.assertEquals(expMessage, obsMessage)

    def test_setAttributesFromString_less_than_20_fields(self):
        line = "chr1\t1804\tT\tC\t0\t1\t100%\t0\t1\t53\t0.98\t0\t1\t0\t0\t1\t0\tC\tEspeceA\n"
        varscanHit = VarscanHit_v2_2_8_WithTag()
        try :
            varscanHit.setAttributesFromString(line)
        except CheckerException, e:
            checkerExceptionInstance = e
        expMessage = "This varscan line (l.) is not complete"
        obsMessage = checkerExceptionInstance.msg
        self.assertEquals(expMessage, obsMessage)
        
    def test_setAttributes(self):
        lResults = ['chr1', '1804', 'T', 'C', '0', '1', '100%', '0', '1', '0', '53', '0.98', '0', '1', '0', '0', '1', '0', 'C', 'EspeceA']
        lineNumber = 1
        
        expChrom = "chr1"
        expPosition = "1804"
        expRef = "T"
        expCns = "C"
        expReadsRef = "0"
        expReadsVar = "1"
        expVarFreq = "100%"
        expStrandsRef = "0"
        expStrandsVar = "1"
        expQualRef = "0"
        expQualVar = "53"
        expPValue = "0.98"
        expMapQualRef = "0"
        expMapQualVar = "1"
        expReadsRefPlus = "0"
        expReadsRefMinus = "0"
        expReadsVarPlus = "1"
        expReadsVarMinus = "0"
        expVar = "C"
        expTag = "EspeceA"
        
        varscanHit = VarscanHit_v2_2_8_WithTag()
        varscanHit.setAttributes(lResults, lineNumber)
        
        obsChrom = varscanHit.getChrom()
        obsPosition = varscanHit.getPosition()
        obsRef = varscanHit.getRef()
        obsCns = varscanHit.getCns()
        obsReadsRef = varscanHit.getReadsRef()
        obsReadsVar = varscanHit.getReadsVar()
        obsVarFreq = varscanHit.getVarFreq()
        obsStrandsRef = varscanHit.getStrandsRef()
        obsStrandsVar = varscanHit.getStrandsVar()
        obsQualRef = varscanHit.getQualRef()
        obsQualVar = varscanHit.getQualVar()
        obsPValue = varscanHit.getPValue()
        obsMapQualRef = varscanHit.getMapQualRef()
        obsMapQualVar = varscanHit.getMapQualVar()
        obsReadsRefPlus = varscanHit.getReadsRefPlus()
        obsReadsRefMinus = varscanHit.getReadsRefMinus()
        obsReadsVarPlus = varscanHit.getReadsVarPlus()
        obsReadsVarMinus = varscanHit.getReadsVarMinus()
        obsVar = varscanHit.getVar()
        obsTag = varscanHit.getTag()
        
        self.assertEquals(expChrom, obsChrom)
        self.assertEquals(expPosition, obsPosition)
        self.assertEquals(expRef, obsRef)
        self.assertEquals(expCns, obsCns)
        self.assertEquals(expReadsRef, obsReadsRef)
        self.assertEquals(expReadsVar, obsReadsVar)
        self.assertEquals(expVarFreq, obsVarFreq)
        self.assertEquals(expStrandsRef, obsStrandsRef)
        self.assertEquals(expStrandsVar, obsStrandsVar)
        self.assertEquals(expQualRef, obsQualRef)
        self.assertEquals(expQualVar, obsQualVar)
        self.assertEquals(expPValue, obsPValue)
        self.assertEquals(expMapQualRef, obsMapQualRef)
        self.assertEquals(expMapQualVar, obsMapQualVar)
        self.assertEquals(expReadsRefPlus, obsReadsRefPlus)
        self.assertEquals(expReadsRefMinus, obsReadsRefMinus)
        self.assertEquals(expReadsVarPlus, obsReadsVarPlus)
        self.assertEquals(expReadsVarMinus, obsReadsVarMinus)
        self.assertEquals(expVar, obsVar)
        self.assertEquals(expTag, obsTag)

    def test_setAttributes_empty_chrom(self):
        lResults = ['', '1804', 'T', 'C', '0', '1', '100%', '0', '1', '0', '53', '0.98', '0', '1', '0', '0', '1', '0', 'C', 'EspeceA']
        lineNumber = 1
        
        varscanHit = VarscanHit_v2_2_8_WithTag()
        checkerExceptionInstance = None
        try:
            varscanHit.setAttributes(lResults, lineNumber)
        except CheckerException, e:
            checkerExceptionInstance = e
        
        expMessage = "The field Chrom is empty in varscan file in line 1"
        obsMessage = checkerExceptionInstance.msg
           
        self.assertEquals(expMessage, obsMessage)

    def test_setAttributes_empty_position(self):
        lResults = ['chr1', '', 'T', 'C', '0', '1', '100%', '0', '1', '0', '53', '0.98', '0', '1', '0', '0', '1', '0', 'C', 'EspeceA']
        lineNumber = 1
        
        varscanHit = VarscanHit_v2_2_8_WithTag()
        checkerExceptionInstance = None
        try:
            varscanHit.setAttributes(lResults, lineNumber)
        except CheckerException, e:
            checkerExceptionInstance = e
        
        expMessage = "The field Position is empty in varscan file in line 1"
        obsMessage = checkerExceptionInstance.msg
           
        self.assertEquals(expMessage, obsMessage)

    def test_setAttributes_empty_ref(self):
        lResults = ['chr1', '1000', '', 'C', '0', '1', '100%', '0', '1', '0', '53', '0.98', '0', '1', '0', '0', '1', '0', 'C', 'EspeceA']
        lineNumber = 1
        
        varscanHit = VarscanHit_v2_2_8_WithTag()
        checkerExceptionInstance = None
        try:
            varscanHit.setAttributes(lResults, lineNumber)
        except CheckerException, e:
            checkerExceptionInstance = e
        
        expMessage = "The field Ref is empty in varscan file in line 1"
        obsMessage = checkerExceptionInstance.msg
           
        self.assertEquals(expMessage, obsMessage)

    def test_setAttributes_empty_cns(self):
        lResults = ['chr1', '1000', 'T', '', '0', '1', '100%', '0', '1', '0', '53', '0.98', '0', '1', '0', '0', '1', '0', 'C', 'EspeceA']
        lineNumber = 1
        
        varscanHit = VarscanHit_v2_2_8_WithTag()
        checkerExceptionInstance = None
        try:
            varscanHit.setAttributes(lResults, lineNumber)
        except CheckerException, e:
            checkerExceptionInstance = e
        
        expMessage = "The field Cons is empty in varscan file in line 1"
        obsMessage = checkerExceptionInstance.msg
           
        self.assertEquals(expMessage, obsMessage)

    def test_setAttributes_empty_var(self):
        lResults = ['chr1', '1000', 'T', 'C', '0', '1', '100%', '0', '1', '0', '53', '0.98', '0', '1', '0', '0', '1', '0', '', 'EspeceA']
        lineNumber = 1
        
        varscanHit = VarscanHit_v2_2_8_WithTag()
        checkerExceptionInstance = None
        try:
            varscanHit.setAttributes(lResults, lineNumber)
        except CheckerException, e:
            checkerExceptionInstance = e
        
        expMessage = "The field varAllele is empty in varscan file in line 1"
        obsMessage = checkerExceptionInstance.msg
           
        self.assertEquals(expMessage, obsMessage)

    def test__eq__notEquals(self):
        varscanHit1 = VarscanHit_v2_2_8_WithTag()
        varscanHit1.setChrom('C02HBa0291P19_LR48')
        varscanHit1.setPosition('34')
        varscanHit1.setRef('A')
        varscanHit1.setCns('T')
        varscanHit1.setVar('T')
        varscanHit1.setVar('EspeceA')
        
        varscanHit2 = VarscanHit_v2_2_8_WithTag()
        varscanHit2.setChrom('C02HBa0291P19_LR48')
        varscanHit2.setPosition('34')
        varscanHit2.setRef('A')
        varscanHit2.setCns('T')
        varscanHit2.setVar('T')
        varscanHit2.setVar('EspeceB')
        
        self.assertFalse(varscanHit1 == varscanHit2)

    def test__eq__Equals(self):
        varscanHit1 = VarscanHit_v2_2_8_WithTag()
        varscanHit1.setChrom('C02HBa0291P19_LR48')
        varscanHit1.setPosition('34')
        varscanHit1.setRef('A')
        varscanHit1.setCns('T')
        varscanHit1.setVar('T')
        varscanHit1.setVar('EspeceA')
        
        varscanHit2 = VarscanHit_v2_2_8_WithTag()
        varscanHit2.setChrom('C02HBa0291P19_LR48')
        varscanHit2.setPosition('34')
        varscanHit2.setRef('A')
        varscanHit2.setCns('T')
        varscanHit2.setVar('T')
        varscanHit2.setVar('EspeceA')
        
        self.assertTrue(varscanHit1 == varscanHit2)
        
    def test_convertVarscanHit_v2_2_8_WithTag_To_VarscanHit_WithTag(self):
        line = "chr1\t1804\tT\tC\t0\t1\t100%\t0\t1\t0\t53\t0.98\t0\t1\t0\t0\t1\t0\tC\tEspeceA\n"
        iVarscanHit_v2_2_8_WithTag = VarscanHit_v2_2_8_WithTag()
        iVarscanHit_v2_2_8_WithTag.setAttributesFromString(line)
        obsVarcanHit_WithTag = iVarscanHit_v2_2_8_WithTag.convertVarscanHit_v2_2_8_WithTag_To_VarscanHit_WithTag()
        
        line = "chr1\t1804\tT\tC\t0\t1\t100%\t0\t1\t0\t53\t0.98\tEspeceA\n"
        expVarcanHit_WithTag = VarscanHit_WithTag()
        expVarcanHit_WithTag.setAttributesFromString(line)
        
        self.assertEquals(expVarcanHit_WithTag, obsVarcanHit_WithTag)

if __name__ == "__main__":
    unittest.main()