from commons.core.stat.Stat import Stat
import unittest

class Test_Stat(unittest.TestCase):
    
    def test__eq__true(self):
        iStat1 = Stat([1, 2, 3, 46])
        iStat2 = Stat([1, 2, 3, 46])
        self.assertTrue(iStat1 == iStat2)

    def test__eq__false(self):
        iStat1 = Stat([1, 2, 3, 4])
        iStat2 = Stat([1, 2, 3, 46])
        self.assertFalse(iStat1 == iStat2)

    def test__eq__disordered_list(self):
        iStat1 = Stat([3, 2, 1, 46])
        iStat2 = Stat([1, 2, 3, 46])
        self.assertTrue(iStat1 == iStat2)

    def test_reset(self):
        lValues = [1, 2, 5, 9, 12, 46]
        iStat = Stat(lValues)
        iStat.reset()
        expValuesList = []
        expSum = 0
        expSum2 = 0
        expN = 0
        expMin = 0
        expMax = 0
        obsValuesList = iStat.getValuesList()
        obsSum = iStat.getSum()
        obsSum2 = iStat.getSumOfSquares()
        obsN = iStat.getValuesNumber()
        obsMin = iStat.getMin()
        obsMax = iStat.getMax()
        self.assertEquals(expValuesList, obsValuesList)
        self.assertEquals(expSum, obsSum)
        self.assertEquals(expSum2, obsSum2)
        self.assertEquals(expN, obsN)
        self.assertEquals(expMin, obsMin)
        self.assertEquals(expMax, obsMax)

    def test_add_EmptyList(self):
        lValues = []
        iStat = Stat(lValues)
        iStat.add(5)
        expValuesList = [5]
        expSum = 5
        expSum2 = 25
        expN = 1
        expMin = 5
        expMax = 5
        obsValuesList = iStat.getValuesList()
        obsSum = iStat.getSum()
        obsSum2 = iStat.getSumOfSquares()
        obsN = iStat.getValuesNumber()
        obsMin = iStat.getMin()
        obsMax = iStat.getMax()
        self.assertEquals(expValuesList, obsValuesList)
        self.assertEquals(expSum, obsSum)
        self.assertEquals(expSum2, obsSum2)
        self.assertEquals(expN, obsN)
        self.assertEquals(expMin, obsMin)
        self.assertEquals(expMax, obsMax)
       
    def test_add_Max(self):
        lValues = [0,1,1]
        iStat = Stat(lValues)
        iStat.add(2)
        expValuesList = [0,1,1,2]
        expSum = 4
        expSum2 = 6
        expN = 4
        expMin = 0
        expMax = 2
        obsValuesList = iStat.getValuesList()
        obsSum = iStat.getSum()
        obsSum2 = iStat.getSumOfSquares()
        obsN = iStat.getValuesNumber()
        obsMin = iStat.getMin()
        obsMax = iStat.getMax()
        self.assertEquals(expValuesList, obsValuesList)
        self.assertEquals(expSum, obsSum)
        self.assertEquals(expSum2, obsSum2)
        self.assertEquals(expN, obsN)
        self.assertEquals(expMin, obsMin)
        self.assertEquals(expMax, obsMax)
       
    def test_add_Min(self):
        lValues = [2,1,1]
        iStat = Stat(lValues)
        iStat.add(0)
        expValuesList = [2,1,1,0]
        expSum = 4
        expSum2 = 6
        expN = 4
        expMin = 0
        expMax = 2
        obsValuesList = iStat.getValuesList()
        obsSum = iStat.getSum()
        obsSum2 = iStat.getSumOfSquares()
        obsN = iStat.getValuesNumber()
        obsMin = iStat.getMin()
        obsMax = iStat.getMax()
        self.assertEquals(expValuesList, obsValuesList)
        self.assertEquals(expSum, obsSum)
        self.assertEquals(expSum2, obsSum2)
        self.assertEquals(expN, obsN)
        self.assertEquals(expMin, obsMin)
        self.assertEquals(expMax, obsMax)
       
    def test_fill_emptyList(self):
        lValues = [2,1,1]
        iStat = Stat(lValues)
        iStat.fill([])
        expValuesList = [2,1,1]
        expSum = 4
        expSum2 = 6
        expN = 3
        expMin = 1
        expMax = 2
        obsValuesList = iStat.getValuesList()
        obsSum = iStat.getSum()
        obsSum2 = iStat.getSumOfSquares()
        obsN = iStat.getValuesNumber()
        obsMin = iStat.getMin()
        obsMax = iStat.getMax()
        self.assertEquals(expValuesList, obsValuesList)
        self.assertEquals(expSum, obsSum)
        self.assertEquals(expSum2, obsSum2)
        self.assertEquals(expN, obsN)
        self.assertEquals(expMin, obsMin)
        self.assertEquals(expMax, obsMax)
       
    def test_fill(self):
        lValues = [2, 1, 1]
        iStat = Stat(lValues)
        iStat.fill([4, 0])
        expValuesList = [2, 1, 1, 4, 0]
        expSum = 8
        expSum2 = 22
        expN = 5
        expMin = 0
        expMax = 4
        obsValuesList = iStat.getValuesList()
        obsSum = iStat.getSum()
        obsSum2 = iStat.getSumOfSquares()
        obsN = iStat.getValuesNumber()
        obsMin = iStat.getMin()
        obsMax = iStat.getMax()
        self.assertEquals(expValuesList, obsValuesList)
        self.assertEquals(expSum, obsSum)
        self.assertEquals(expSum2, obsSum2)
        self.assertEquals(expN, obsN)
        self.assertEquals(expMin, obsMin)
        self.assertEquals(expMax, obsMax)
        
    def test_mean_emptyList(self):
        lValues = []
        iStat = Stat(lValues)
        expMean = 0
        obsMean = iStat.mean()
        self.assertEquals(expMean, obsMean)
        
    def test_mean(self):
        lValues = [0, 1]
        iStat = Stat(lValues)
        expMean = 0.5
        obsMean = iStat.mean()
        self.assertEquals(expMean, obsMean)
        
    def test_var_emptyList(self):
        lValues = []
        iStat = Stat(lValues)
        expVar = 0
        obsVar = iStat.var()
        self.assertEquals(expVar, obsVar)
        
    def test_var(self):
        lValues = [1, 1, 2]
        iStat = Stat(lValues)
        expVar = round(1/float(3), 5)
        obsVar = round(iStat.var(), 5)
        self.assertEquals(expVar, obsVar)
        
    def test_var2(self):
        lValues = [1,6,3,4,9,6]
        iStat = Stat(lValues)
        expVar = 7.76667
        obsVar = round(iStat.var(), 5)
        self.assertEquals(expVar, obsVar)
        
    def test_var_null(self):
        lValues = [87.340000000000003, 87.340000000000003, 87.340000000000003, 87.340000000000003, 87.340000000000003, 87.340000000000003, 87.340000000000003]
        iStat = Stat(lValues)
        expVar = 0
        obsVar = round(iStat.var(),5)
        self.assertEquals(expVar, obsVar)
        
    def test_sd(self):
        lValues = [1, 1, 2]
        iStat = Stat(lValues)
        expSd = round(0.577350269, 5)
        obsSd = round(iStat.sd(), 5)
        self.assertEquals(expSd, obsSd)
        
    def test_sd_null(self):
        lValues = [87.340000000000003, 87.340000000000003, 87.340000000000003, 87.340000000000003, 87.340000000000003, 87.340000000000003, 87.340000000000003]
        iStat = Stat(lValues)
        expSd = 0
        obsSd = round(iStat.sd(), 5)
        self.assertEquals(expSd, obsSd)

    def test_cv(self):
        lValues = [1, 1, 2]
        iStat = Stat(lValues)
        expSd = round(0.433012702, 5)
        obsSd = round(iStat.cv(), 5)
        self.assertEquals(expSd, obsSd)

    def test_cv_mean_is_nul(self):
        lValues = [1, -1]
        iStat = Stat(lValues)
        expSd = 0
        obsSd = iStat.cv()
        self.assertEquals(expSd, obsSd)
        
    def test_median_emptyList(self):
        lValues = []
        iStat = Stat(lValues)
        expMedian = "NA"
        obsMedian = iStat.median()
        self.assertEquals(expMedian, obsMedian)
        
    def test_median_even(self):
        lValues = [1, 2, 3, 4, 1, 2, 54, 6, 7]
        iStat = Stat(lValues)
        expMedian = 3
        obsMedian = iStat.median()
        self.assertEquals(expMedian, obsMedian)
        
    def test_median_odd(self):
        lValues = [1, 2, 3, 4, 2, 54, 6, 7]
        iStat = Stat(lValues)
        expMedian = 3.5
        obsMedian = iStat.median()
        self.assertEquals(expMedian, obsMedian)
        
    def test_kurtosis_flat(self):
        lValues = [1, 1, 1]
        iStat = Stat(lValues)
        expKurtosis = 0
        obsKurtosis = iStat.kurtosis()
        self.assertEquals(expKurtosis, obsKurtosis)
        
    def test_kurtosis_peak(self):
        lValues = [1, 100, -5]
        iStat = Stat(lValues)
        expKurtosis = round(712872278.6609683, 2)
        obsKurtosis = round(iStat.kurtosis(), 2)
        self.assertEquals(expKurtosis, obsKurtosis)
 
    def test_kurtosis_normal(self):
        lValues = [-1, 0, 1.64, 1.64, 0, -1]
        iStat = Stat(lValues)
        expKurtosis = 3.0
        obsKurtosis = round(iStat.kurtosis(), 1)
        self.assertEquals(expKurtosis, obsKurtosis)
        
    def test_sort(self):
        lValues = [-1, 0, 1.64, 1.64, 0, -1]
        iStat = Stat(lValues)
        expSort = [-1, -1, 0, 0, 1.64, 1.64]
        obsSort = iStat.sort()
        self.assertEquals(expSort, obsSort)
        
    def test_sort_reverse(self):
        lValues = [-1, 0, 1.64, 1.64, 0, -1]
        iStat = Stat(lValues)
        expSort = [1.64, 1.64, 0, 0, -1, -1]
        obsSort = iStat.sort(True)
        self.assertEquals(expSort, obsSort)
        
    def test_sort_emptyList(self):
        lValues = []
        iStat = Stat(lValues)
        expSort = []
        obsSort = iStat.sort()
        self.assertEquals(expSort, obsSort)
        
    def test_quantile_emptyList(self):
        lValues = []
        iStat = Stat(lValues)
        expQuantile = 0
        obsQuantile = iStat.quantile(0.25)
        self.assertEquals(expQuantile, obsQuantile)
        
    def test_quantile_0perc(self):
        lValues = [0, 2.64, 1.64, -1, 5]
        iStat = Stat(lValues)
        expQuantile = -1
        obsQuantile = iStat.quantile(0)
        self.assertEquals(expQuantile, obsQuantile)
        
    def test_quantile_25perc(self):
        lValues = [0, 2.64, 1.64, -1, 5]
        iStat = Stat(lValues)
        expQuantile = 0
        obsQuantile = iStat.quantile(0.25)
        self.assertEquals(expQuantile, obsQuantile)
        
    def test_quantile_41perc(self):
        lValues = [0, 2.64, 1.64, -1, 5]
        iStat = Stat(lValues)
        expQuantile = 1.64
        obsQuantile = iStat.quantile(0.41)
        self.assertEquals(expQuantile, obsQuantile)
        
    def test_quantile_75perc(self):
        lValues = [0, 2.64, 1.64, -1, 5]
        iStat = Stat(lValues)
        expQuantile = 2.64
        obsQuantile = iStat.quantile(0.75)
        self.assertEquals(expQuantile, obsQuantile)
        
    def test_quantile_81perc(self):
        lValues = [0, 2.64, 1.64, -1, 5]
        iStat = Stat(lValues)
        expQuantile = 5
        obsQuantile = iStat.quantile(0.81)
        self.assertEquals(expQuantile, obsQuantile)
        
    def test_quantile_100perc(self):
        lValues = [0, 2.64, 1.64, -1, 5]
        iStat = Stat(lValues)
        expQuantile = 5
        obsQuantile = iStat.quantile(1)
        self.assertEquals(expQuantile, obsQuantile)
        
    def test_N50(self):
        lValues = [10, 10, 2, 16, 3, 4, 5]
        iStat = Stat(lValues)
        expN50 = 10
        obsN50 = iStat.N50()
        self.assertEquals(expN50, obsN50)

    def test_N50SpecialValues(self):
        lValues = [1, 100, 2, 3]
        iStat = Stat(lValues)
        expN50 = 100
        obsN50 = iStat.N50()
        self.assertEquals(expN50, obsN50)
        
if __name__ == "__main__":
    unittest.main()