#! /usr/bin/env python
#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
"""Split a FASTA file into several shorter ones"""

from optparse import OptionParser
from commons.core.parsing.SequenceListParser import *
from commons.core.writer.FastaWriter import *
from SMART.Java.Python.misc.Progress import *


if __name__ == "__main__":
    
    # parse command line
    description = "Sequence List Splitter v1.0.1: Split a list of big sequences into small chunks. [Category: Personnal]"

    parser = OptionParser(description = description)
    parser.add_option("-i", "--input",     dest="inputFileName",   action="store",                         type="string", help="input file [compulsory] [format: file in FASTA format]")
    parser.add_option("-o", "--output",    dest="outputFileNames", action="store",                         type="string", help="output files [compulsory] [format: output file in FASTA format]")
    parser.add_option("-n", "--number",    dest="number",          action="store",      default=10,        type="int",    help="number of splits [compulsory] [format: int] [default: 10]")
    parser.add_option("-v", "--verbosity", dest="verbosity",       action="store",      default=1,         type="int",    help="trace level [format: int]")
    parser.add_option("-l", "--log",       dest="log",             action="store_true", default=False,                    help="write a log file [format: bool] [default: false]")
    (options, args) = parser.parse_args()

    if options.log:
        logHandle = open(options.outputFileNames + ".log", "w")

    # split file
    sequenceListParser = SequenceListParser(options.inputFileName, options.verbosity)
    nbSequences                = sequenceListParser.getNbSequences()
    nbSequencesByFile    = math.ceil(nbSequences / options.number)

    # write into files
    currentFileNumber = 1
    writer            = FastaWriter("%s%i.fasta" % (options.outputFileNames, currentFileNumber), options.verbosity)
    nbSequencesHere   = 0
    progress          = Progress(nbSequences, "Writing files", options.verbosity)
    for sequence in sequenceListParser.getIterator():
        writer.addSequence(sequence)
        nbSequencesHere += 1
        if nbSequencesHere == nbSequencesByFile:
            currentFileNumber += 1
            writer             = FastaWriter("%s%i.fasta" % (options.outputFileNames, currentFileNumber), options.verbosity)
            nbSequencesHere    = 0
        progress.inc()
    progress.done()
