import unittest
from commons.core.parsing.CoordsParser import CoordsParser
from SMART.Java.Python.mappingToCoordinates import MappingToCoordinates


class Test_CoordsParser(unittest.TestCase):
    

    def test_Parser(self):
        parser = CoordsParser("data/testCoordsParser.coords")
        
        cpt = 0
        for mapping in parser.getIterator():
            transcript = mapping.getTranscript()
            cpt += 1
            if cpt == 1:
                self.assertEqual(transcript.getChromosome(), "scaffold_1")
                self.assertEqual(transcript.getName(), "gi|240254421:1-30427671")
                self.assertEqual(transcript.getStart(), 1)
                self.assertEqual(transcript.getEnd(), 6251)
                self.assertEqual(transcript.getDirection(), -1)
                self.assertEqual(transcript.getNbExons(), 1)
                self.assertEqual(transcript.getTagValue("identity"), 89.030000000000001)
                exons = transcript.getExons()
                self.assertEqual(exons[0].getChromosome(), "scaffold_1")
                self.assertEqual(exons[0].getStart(), 1)
                self.assertEqual(exons[0].getEnd(), 6251)
                self.assertEqual(exons[0].getDirection(), -1)
                self.assertEqual(transcript.getSize(), 6251)
            elif cpt == 2:
                self.assertEqual(transcript.getChromosome(), "scaffold_1")
                self.assertEqual(transcript.getName(), "gi|240254421:1-30427671")
                self.assertEqual(transcript.getStart(), 9127)
                self.assertEqual(transcript.getEnd(), 11947)
                self.assertEqual(transcript.getDirection(), -1)
                self.assertEqual(transcript.getNbExons(), 1)
                self.assertEqual(transcript.getTagValue("identity"), 90.450000000000003)
                exons = transcript.getExons()
                self.assertEqual(exons[0].getChromosome(), "scaffold_1")
                self.assertEqual(exons[0].getStart(), 9127)
                self.assertEqual(exons[0].getEnd(), 11947)
                self.assertEqual(exons[0].getDirection(), -1)
                self.assertEqual(transcript.getSize(), 2821)
            if cpt == 3:
                self.assertEqual(transcript.getChromosome(), "scaffold_1")
                self.assertEqual(transcript.getName(), "gi|240254421:1-30427671")
                self.assertEqual(transcript.getStart(), 12201)
                self.assertEqual(transcript.getEnd(), 12953)
                self.assertEqual(transcript.getDirection(), -1)
                self.assertEqual(transcript.getNbExons(), 1)
                exons = transcript.getExons()
                self.assertEqual(exons[0].getChromosome(), "scaffold_1")
                self.assertEqual(exons[0].getStart(), 12201)
                self.assertEqual(exons[0].getEnd(), 12953)
                self.assertEqual(exons[0].getDirection(), -1)
                self.assertEqual(transcript.getSize(), 753)
            
    def test_Parser_showcoord(self):
        parser = CoordsParser("data/testCoordsParser_showcoord.coords")
        expTranscriptCount = 1
        obsTranscriptCount = 0
        
        for mapping in parser.getIterator():
            transcript = mapping.getTranscript()
            obsTranscriptCount += 1
            self.assertEqual(transcript.getChromosome(), "mivi_sl_A1_scaffold00001")
            self.assertEqual(transcript.getName(), "mivi_sl_A2_scaffold00003")
            self.assertEqual(transcript.getStart(), 296)
            self.assertEqual(transcript.getEnd(), 2292)
            self.assertEqual(transcript.getDirection(), 1)
            self.assertEqual(transcript.getTagValue("identity"), 98.30)
            self.assertEqual(transcript.getTagValue("target_pident"), 98.30)                
            self.assertEqual(transcript.getTagValue("target_pcover"), 3.32)
            self.assertEqual(transcript.getTagValue("target_length"), 60273)                
            self.assertEqual(transcript.getTagValue("Target"), "mivi_sl_A2_scaffold00003 1 2001")
            self.assertEqual(transcript.getSize(), 1997)
                
        self.assertEquals(expTranscriptCount, obsTranscriptCount)
                            
    def test_Parser_showcoord_promer(self):
        parser = CoordsParser("data/testCoordsParser_showcoord_promer.coords")
        expTranscriptCount = 1
        obsTranscriptCount = 0
        
        for mapping in parser.getIterator():
            transcript = mapping.getTranscript()
            obsTranscriptCount += 1
            self.assertEqual(transcript.getChromosome(), "mivi_sl_A1_scaffold00001")
            self.assertEqual(transcript.getName(), "mivi_sl_A2_scaffold00003")
            self.assertEqual(transcript.getStart(), 291)
            self.assertEqual(transcript.getEnd(), 1229)
            self.assertEqual(transcript.getDirection(), -1)
            self.assertEqual(transcript.getTagValue("identity"), 94.25)
            self.assertEqual(transcript.getTagValue("target_pident"), 94.25)                
            self.assertEqual(transcript.getTagValue("target_pcover"), 1.56)
            self.assertEqual(transcript.getTagValue("target_length"), 60273)                
            self.assertEqual(transcript.getTagValue("Target"), "mivi_sl_A2_scaffold00003 939 1")
            self.assertEqual(transcript.getSize(), 939)
                
        self.assertEquals(expTranscriptCount, obsTranscriptCount)
        
 
if __name__ == '__main__':
        unittest.main()

