from commons.core.parsing.CrossSsrAndBesMappedByBlatToGff import CrossSsrAndBesMappedByBlatToGff
from commons.core.parsing.SsrParser import SsrParser

import unittest
import os


class Test_CrossSsrAndBesMappedByBlatToGff(unittest.TestCase):


    def test_createDictOfSsrParser(self):
        obsDictSsrParser = {}
        
        ssrFileName = 'input_SSR_Resuts.tab'
        SSRFile = open(ssrFileName, 'w')
        SSRFile.write('BES_name\tBES_redundancy\tSSR_di/tri/tetranucleotide\tSSR_Motif\tSSR_Motif_number\tSSR_start\tSSR_end\tBES_size\n')
        SSRFile.write('MRRE1H001A12RM1\t1\t4\tttta\t6\t272\t295\t724\n')
        SSRFile.write('MRRE1H001B01RM1\t1\t3\taat\t8\t264\t287\t683\n')
        SSRFile.write('MRRE1H001B07RM1\t1\t2\tta\t19\t153\t190\t734\n')
        SSRFile.write('MRRE1H001B07RM1\t2\t2\taata\t25\t83\t90\t734\n')
        SSRFile.close()
        
        iCrossSsrAndBesMappedByBlatToGff = CrossSsrAndBesMappedByBlatToGff()
        iCrossSsrAndBesMappedByBlatToGff._inputFileSSR = ssrFileName
        obsDictSsrParser = iCrossSsrAndBesMappedByBlatToGff.createDictOfSsrParser(obsDictSsrParser)
        
        SsrParser1 = SsrParser('MRRE1H001A12RM1', '1', '4', 'ttta', '6', '272', '295', '724')
        SsrParser2 = SsrParser('MRRE1H001B01RM1', '1', '3', 'aat', '8', '264', '287', '683')
        SsrParser3 = SsrParser('MRRE1H001B07RM1', '1', '2', 'ta', '19', '153', '190', '734')
        SsrParser4 = SsrParser('MRRE1H001B07RM1', '2', '2', 'aata', '25', '83', '90', '734')
        
        expDictSsrParser = {
                         'MRRE1H001A12RM1': [SsrParser1], 
                         'MRRE1H001B01RM1': [SsrParser2],
                         'MRRE1H001B07RM1': [SsrParser3, SsrParser4]
                        }
        
        self.assertEquals(expDictSsrParser, obsDictSsrParser)
        os.remove(ssrFileName)
        
    def test_convertSSRPositionsToBlatPositions_strand_FW(self):
        ssrPos = 75
        blatPosStart = 10501475
        blatPosEnd = 10501985
        strand = '+'
        iCrossSsrAndBesMappedByBlatToGff = CrossSsrAndBesMappedByBlatToGff()
        obsNewPos = iCrossSsrAndBesMappedByBlatToGff.convertSSRPositionsToChromPositions(ssrPos, blatPosStart, blatPosEnd, strand)
        expNewPos = 10501549
        self.assertEquals(expNewPos, obsNewPos)
        
    def test_convertSSRPositionsToBlatPositions_strand_RV(self):
        ssrPos = 75
        blatPosStart = 10501475
        blatPosEnd = 10501985
        strand = '-'
        iCrossSsrAndBesMappedByBlatToGff = CrossSsrAndBesMappedByBlatToGff()
        obsNewPos = iCrossSsrAndBesMappedByBlatToGff.convertSSRPositionsToChromPositions(ssrPos, blatPosStart, blatPosEnd, strand)
        expNewPos = 10501911
        self.assertEquals(expNewPos, obsNewPos)
        
    def test_getSsrMotif(self):
        ssrMotif = 'atg'
        ssrNbMotif = 4
        iCrossSsrAndBesMappedByBlatToGff = CrossSsrAndBesMappedByBlatToGff()
        obsSsrSeq = iCrossSsrAndBesMappedByBlatToGff.getSsrSeq(ssrMotif, ssrNbMotif)
        expSsrSeq = 'atgatgatgatg'
        self.assertEquals(expSsrSeq, obsSsrSeq)

if __name__ == "__main__":
    unittest.main()