import unittest
from commons.core.sql.Job import Job

class Test_Job(unittest.TestCase):

    def test__eq__(self):
        self._job = Job(jobid=0, jobname="test", groupid="test", queue="test",command="test", launcherFile="test", node="test", lResources="mem_free=1G" )
        o =  Job(jobid=0, jobname="test", groupid="test", queue="test",command="test", launcherFile="test", node="test", lResources="mem_free=1G" )
        self.assertEqual( self._job, o ) # same data
        o =  Job(jobid=1, jobname="test", groupid="test", queue="test",command="test", launcherFile="test", node="test", lResources="mem_free=1G" )
        self.assertNotEqual( self._job, o ) # different jobid        
        o =  Job(jobid=0, jobname="test1", groupid="test", queue="test",command="test", launcherFile="test", node="test", lResources="mem_free=1G" )
        self.assertNotEqual( self._job, o ) # different jobname
        o =  Job(jobid=0, jobname="test", groupid="test1", queue="test",command="test", launcherFile="test", node="test", lResources="mem_free=1G" )
        self.assertNotEqual( self._job, o ) # different groupid
        o =  Job(jobid=0, jobname="test", groupid="test", queue="test1",command="test", launcherFile="test", node="test", lResources="mem_free=1G" )
        self.assertNotEqual( self._job, o ) # different queue        
        o =  Job(jobid=0, jobname="test", groupid="test", queue="test",command="test1", launcherFile="test", node="test", lResources="mem_free=1G" )
        self.assertNotEqual( self._job, o ) # different command
        o =  Job(jobid=0, jobname="test", groupid="test", queue="test",command="test", launcherFile="test1", node="test", lResources="mem_free=1G" )
        self.assertNotEqual( self._job, o ) # different launcherFile
        o =  Job(jobid=0, jobname="test", groupid="test", queue="test",command="test", launcherFile="test", node="test1", lResources="mem_free=1G" )
        self.assertNotEqual( self._job, o ) # different node
        o =  Job(jobid=0, jobname="test", groupid="test", queue="test",command="test", launcherFile="test", node="test", lResources="mem_free=2G" )
        self.assertNotEqual( self._job, o ) # different lResources
        o =  Job(jobid=0, jobname="test", groupid="test", queue="test",command="test", launcherFile="test", node="test", lResources="mem_free=1G", parallelEnvironment="multithread 6" )
        self.assertNotEqual( self._job, o ) # different parallelEnvironment
                
if __name__ == "__main__":
    unittest.main()