# Copyright INRA (Institut National de la Recherche Agronomique)
# http://www.inra.fr
# http://urgi.versailles.inra.fr
#
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software.  You can  use, 
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info". 
#
# As a counterpart to the access to the source code and  rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty  and the software's author,  the holder of the
# economic rights,  and the successive licensors  have only  limited
# liability. 
#
# In this respect, the user's attention is drawn to the risks associated
# with loading,  using,  modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean  that it is complicated to manipulate,  and  that  also
# therefore means  that it is reserved for developers  and  experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or 
# data to be ensured and,  more generally, to use and operate it in the 
# same conditions as regards security. 
#
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.


import unittest
import os
from commons.core.checker.OldConfigChecker import ConfigChecker
from commons.core.checker.ConfigException import ConfigException

class Test_ConfigChecker( unittest.TestCase ):
    
    def setUp(self):
        pass
    
    def tearDown(self):
        pass
    
    
    def testFileNotFound(self):
        exceptionExpected = None
        configChecker = ConfigChecker("",{})
        try :
            configChecker.check("noExistsFile.cfg")
        except ConfigException, ce:
            exceptionExpected = ce
        
        self.assertTrue(exceptionExpected != None)
        msg = exceptionExpected.messages[0]
        self.assertTrue(msg.startswith("CONFIG FILE not found - "))
        
        
    def testNoSectionInConfigFile (self):
        exceptionExpected = None
        dummyFile = open("dummyFile.cfg", "w")
        configChecker = ConfigChecker("dummySection",{})
        try :
            configChecker.check("dummyFile.cfg")
        except ConfigException, ce:
            exceptionExpected = ce
        
        self.assertTrue(exceptionExpected != None)
        msg = exceptionExpected.messages[0]
        self.assertTrue(msg.startswith("[dummySection]" + " section not found - "))
        
        os.remove("dummyFile.cfg")
        
        
    def testNoOptionInConfigFile (self):
        exceptionExpected = None
        MockConfigFile("dummyConfig.cfg",{})
        configChecker = ConfigChecker("blaster_config",{"dummy":""})
        try :
            configChecker.check("dummyConfig.cfg")
        except ConfigException, ce:
            exceptionExpected = ce
        
        self.assertTrue(exceptionExpected != None)
        msg = exceptionExpected.messages[0]
        self.assertTrue(msg.startswith("[blaster_config] - No option 'dummy' in section: 'blaster_config'"))
        os.remove("dummyConfig.cfg")
        
        
class MockConfigFile:
    
    def __init__ (self, fileName, optionsDict):
        self._fileName = fileName
        config = open(fileName, "w");
        config.write("[blaster_config]\n")
        for key in optionsDict.keys():
            config.write(key + ":" + optionsDict[key] + "\n")
        config.close()
        
        
test_suite = unittest.TestSuite()
test_suite.addTest( unittest.makeSuite( Test_ConfigChecker ) )
if __name__ == "__main__":
    unittest.TextTestRunner(verbosity=2).run( test_suite )
