class SlidingWindow(object):
        
    def __init__( self, length = 1, overlap = 1 ):        
        self._length = length
        self._overlap = overlap
        self._start = 1
        self._end = length
        self._step = length - overlap

    def slideWindowOnce(self):
        self._start = self._start + self._step
        self._end = self._end + self._step
    
    def getStart(self):
        return self._start
    
    def getEnd(self):
        return self._end
    
    def setStart(self, start):
        self._start = start
    
    def setEnd(self, end):
        self._end = end
    
    def getLength(self):
        return self._length
    
    def getOverlap(self):
        return self._overlap
    
    def setLength(self, length):
        self._length = length
        
    def setOverlap(self, overlap):
        self._overlap = overlap
    
    def getSlidingMsg(self):
        return "Window is sliding : %s %s" %(self._start, self._end)

class SlidingWindowToCountMatchingBases(SlidingWindow):
    
    def getSetLengthOnWindow( self, iSet ):
        if self._isSetIncludedInTheWindow(iSet):
            return iSet.getLength()
        if self._isWindowIncludedInTheSet(iSet):
            return self._length
        elif self._isSetOverlapTheRightSideOfTheWindow(iSet):
            return self._end - iSet.getMin()+1
        elif self._isSetOverlapTheLeftSideOfTheWindow(iSet):
            return iSet.getMax() - self._start+1
        
    def getCoordSetOnWindow( self, iSet ):
        if self._isSetIncludedInTheWindow(iSet):
            return iSet.getStart(), iSet.getEnd()
        if self._isWindowIncludedInTheSet(iSet):
            return self.getStart(), self.getEnd()
        elif self._isSetOverlapTheRightSideOfTheWindow(iSet):
            return iSet.getStart(), self.getEnd()
        elif self._isSetOverlapTheLeftSideOfTheWindow(iSet):
            return self.getStart(), iSet.getEnd()
        
    def _isSetIncludedInTheWindow(self, feature):
        return feature.getMin() >= self._start and feature.getMax() <= self._end
    
    def _isWindowIncludedInTheSet(self, feature):
        return self._start >= feature.getMin() and self._end <= feature.getMax()

    def _isSetOverlapTheRightSideOfTheWindow(self, feature):
        return feature.getMin() <= self._end and feature.getMin() >= self._start

    def _isSetOverlapTheLeftSideOfTheWindow(self, feature):
        return feature.getMax() <= self._end and feature.getMax() >= self._start    
