#!/usr/bin/env python

import os
import sys
import time
import shutil
from commons.core.checker.RepetException import RepetException
from commons.core.sql.TableJobAdaptator import TableJobAdaptator
from commons.core.sql.DbFactory import DbFactory
from commons.core.sql.Job import Job

try:
	newDir = None
	print os.uname()
	beginTime = time.time()
	print 'beginTime=%f' % beginTime
	print "work in dir '@@tmpDir@@'"
	sys.stdout.flush()
	if not os.path.exists( "@@tmpDir@@" ):
		raise IOError("ERROR: temporary directory '@@tmpDir@@' doesn't exist")
	
	minFreeGigaInTmpDir = 1
	freeSpace = os.statvfs("@@tmpDir@@")
	if ((freeSpace.f_bavail * freeSpace.f_frsize) / 1073741824.0 < minFreeGigaInTmpDir):
		raise RepetException("ERROR: less than %iG of input file in '@@tmpDir@@'" % minFreeGigaInTmpDir)
	
	os.chdir("@@tmpDir@@")
	newDir = "@@groupId@@_@@jobName@@_@@time@@"
	if os.path.exists(newDir):
		shutil.rmtree(newDir)
	os.mkdir(newDir)
	os.chdir(newDir)
	
	iJob = Job(jobname = "@@jobName@@", groupid = "@@groupId@@", launcherFile = "@@launcher@@", node = os.getenv("HOSTNAME"))
	iDb = DbFactory.createInstance()
	iTJA = TableJobAdaptator(iDb, "@@jobTableName@@")
	print "current status: %s" % iTJA.getJobStatus(iJob)
	iTJA.changeJobStatus(iJob, "running")
	print "updated status: %s" % iTJA.getJobStatus(iJob)
	sys.stdout.flush()
	iDb.close()
	
	@@cmdStart@@
	if log != 0:
		raise RepetException("ERROR: job returned %i" % log)
	else:
		print "job finished successfully"
	sys.stdout.flush()
	@@cmdFinish@@
	
	os.chdir("..")
	shutil.rmtree(newDir)
	
	iDb = DbFactory.createInstance()
	iTJA = TableJobAdaptator(iDb, "@@jobTableName@@")
	print "current status: %s" % iTJA.getJobStatus(iJob)
	iTJA.changeJobStatus(iJob, "finished")
	print "updated status: %s" % iTJA.getJobStatus(iJob)
	sys.stdout.flush()
	iDb.close()
	
	endTime = time.time()
	print 'endTime=%f' % endTime
	print 'executionTime=%f' % (endTime - beginTime)
	print os.uname()
	sys.stdout.flush()

except IOError, e :
	print e
	iJob = Job(jobname = "@@jobName@@", groupid = "@@groupId@@", launcherFile = "@@launcher@@", node = os.getenv("HOSTNAME"))
	iDb = DbFactory.createInstance()
	iTJA = TableJobAdaptator(iDb, "@@jobTableName@@")
	print "current status: %s" % iTJA.getJobStatus(iJob)
	iTJA.changeJobStatus(iJob, "error")
	print "updated status: %s" % iTJA.getJobStatus(iJob)
	sys.stdout.flush()
	iDb.close()
	sys.exit(1)

except Exception, e :
	print "tmpDir is : @@tmpDir@@"
	print "cDir is : @@cDir@@"
	print e
	if newDir != None and os.path.exists("../%s" % newDir) and not os.path.exists("@@cDir@@/%s" % newDir):
		os.chdir("..")
		shutil.move(newDir, "@@cDir@@/%s" % newDir)
	iJob = Job(jobname = "@@jobName@@", groupid = "@@groupId@@", launcherFile = "@@launcher@@", node = os.getenv("HOSTNAME"))
	iDb = DbFactory.createInstance()
	iTJA = TableJobAdaptator(iDb, "@@jobTableName@@")
	print "current status: %s" % iTJA.getJobStatus(iJob)
	iTJA.changeJobStatus(iJob, "error")
	print "updated status: %s" % iTJA.getJobStatus(iJob)
	sys.stdout.flush()
	iDb.close()
	sys.exit(1)
