import os
import time

class WriteScript(object):

    def __init__(self, job = None, jobdb = None, cdir = "", tmpdir = "", chooseTemplateWithCopy = False, chooseTemplateLight = False):
        self._iJob = job
        self._iJobdb = jobdb
        self._cDir = cdir
        self._tmpDir = tmpdir
        self._chooseTemplateWithCopy = chooseTemplateWithCopy
        self._chooseTemplateLight = chooseTemplateLight

    def run(self, cmdStart, cmdFinish, pyFileName, cmdSize = "", cmdCopy = ""):
        if self._chooseTemplateLight:
            d = self.createJobScriptLightDict(cmdStart, cmdFinish, cmdSize, cmdCopy)
        else:
            d = self.createJobScriptDict(cmdStart, cmdFinish, cmdSize, cmdCopy)
        self.fillTemplate(pyFileName, d)
    
    def fillTemplate(self, outputFileName, dict):
        if self._chooseTemplateWithCopy:
            inputFileName = "%s/commons/core/launcher/JobScriptWithFilesCopyTemplate.py" % os.environ["REPET_PATH"]
        else:
            inputFileName = "%s/commons/core/launcher/JobScriptTemplate.py" % os.environ["REPET_PATH"]

        if self._chooseTemplateLight:
            inputFileName = "%s/commons/core/launcher/JobScriptTemplateLight.py" % os.environ["REPET_PATH"]
            
        input = open(inputFileName, "r")
        data = input.read()
        input.close()
        for key, value in dict.items():
            data = data.replace("@@%s@@" % key, value)
        output = open(outputFileName, "w")
        output.write(data)
        output.close()
    
    def createJobScriptDict(self, cmdStart, cmdFinish, cmdSize, cmdCopy):
        dict = {
         "tmpDir" : self._tmpDir,
         "jobTableName" : self._iJobdb._table,
         "groupId" : self._iJob.groupid,
         "jobName" : self._iJob.jobname,
         "launcher" : self._iJob.launcher,
         "time" : time.strftime("%Y%m%d-%H%M%S"),
         "repet_path" : os.environ["REPET_PATH"],
         "repet_host" : os.environ["REPET_HOST"],
         "repet_user" : os.environ["REPET_USER"],
         "repet_pw" : os.environ["REPET_PW"],
         "repet_db" : os.environ["REPET_DB"],
         "repet_port" : os.environ["REPET_PORT"],
         "cmdStart" : cmdStart,
         "cmdFinish" : cmdFinish,
         "cDir" : self._cDir,
         "cmdSize" : cmdSize,
         "cmdCopy" : cmdCopy
            }      
        return dict
    
    def createJobScriptLightDict(self, cmdStart, cmdFinish, cmdSize, cmdCopy):
        dict = {
         "tmpDir" : self._tmpDir,
         "jobTableName" : self._iJobdb._table,
         "groupId" : self._iJob.groupid,
         "jobName" : self._iJob.jobname,
         "launcher" : self._iJob.launcher,
         "time" : time.strftime("%Y%m%d-%H%M%S"),
         "repet_path" : os.environ["REPET_PATH"],
         "cmdStart" : cmdStart,
         "cmdFinish" : cmdFinish,
         "cDir" : self._cDir,
         "cmdSize" : cmdSize,
         "cmdCopy" : cmdCopy
            }      
        return dict
