import unittest
from commons.core.stat.Stat import Stat


class Test_F_Stat(unittest.TestCase):


    def test_output(self):
        lValues = [0, -1, -5, 112, 10.2, 0.5, 4, -0.5]
        iStat = Stat(lValues)
        expString = "n=8 mean=15.025 var=1554.934 sd=39.433 min=-5.000 med=0.250 max=112.000"
        self.assertEquals(expString, iStat.string())
        
    def test_outputQuantile(self):
        lValues = [0, -1, -5, 112, 10.2, 0.5, 4, -0.5]
        iStat = Stat(lValues)
        expString = "n=8 min=-5.000 Q1=-0.500 median=0.500 Q3=10.200 max=112.000"
        self.assertEquals(expString, iStat.stringQuantiles())
        
        
if __name__ == "__main__":
    unittest.main()