#! /usr/bin/env python

import os
import sys
import getopt
from commons.core.checker.CheckerException import CheckerException

SMART_PATH = "%s/SMART" % os.environ["REPET_PATH"]

class WrappGetLetterDistribution(object):
    
    def __init__(self):
        self._inputFileName = ""
        self._inputFileFormat = ""
        self._outputFileName = "tmpOutputFile"
        self._csv = False

    def help( self ):
        print 
        print "usage: %s [ options ]" % ( sys.argv[0] )
        print "options:"
        print "     -h: this help"
        print "     -i: input file"
        print "     -f: 'fasta' or 'fastq'"
        print "     -c: CSV output file"
        print "     -a: first PNG output file"
        print "     -b: second PNG output file"
        print
        print "Exemple:"
        print
        print "1:\n\tpython WrappGetLetterDistribution.py -i inputFile.fasta -f fasta -c outputFile1.csv -a outputFile2.png -b outputFile3.png"
        print
        print "2:\n\tpython WrappGetLetterDistribution.py -i inputFile.fastq -f fastq -c outputFile1.csv -a outputFile2.png -b outputFile3.png"
        print
        print


    def setAttributesFromCommandLine(self):
        try:
            opts, args = getopt.getopt( sys.argv[1:], "hi:f:a:b:c:" )
        except getopt.GetoptError, err:
            print str(err); sys.exit(1)
        for o, a in opts:
            if o == "-h":
                self.help()
                sys.exit(0)
            if o == "-i":
                self._inputFileName = a
            elif o == "-f":
                self._inputFileFormat = a
            elif o == "-c":             
                self._outputFileNameCSV = a  
                self._csv = True
            elif o == "-a":
                self._outputFileNamePNG = a
            elif o == "-b":
                self._outputFileNamePerNtPNG = a 

    def checkAttributes(self):
        lMsg = []
        if self._inputFileName == "" and not os.path.exists(self._inputFileName):
            lMsg.append("ERROR: This input file doesn't exist!")
        if self._inputFileFormat == "":
            lMsg.append("ERROR: No input file format specified in option!")
        if self._outputFileNamePNG == "":
            lMsg.append("ERROR: No output file.png specified in option!")            
        if self._outputFileNamePerNtPNG == "":
            lMsg.append("ERROR: No output filePerNt.png specified in option!")
        if self._outputFileNameCSV == "" and self._csv == True :
            lMsg.append("ERROR: No output file.csv specified in option!")   
            
        print ">>> lMsg " + str(lMsg)
        if lMsg != []:
            exp = CheckerException()
            exp.setMessages(lMsg)
            raise (exp)

    def _cleanWorkingDir(self, cDir):
        os.system("rm %s/tmpData* %s/tmpScript*" % (cDir, cDir))
        
    def wrapp(self):
        self.checkAttributes()
	cDir = os.getcwd()

        if self._csv == True:
            os.system("python %s/Java/Python/getLetterDistribution.py -i %s -f %s -o %s/%s -c" % (SMART_PATH, self._inputFileName, self._inputFileFormat, cDir, self._outputFileName))
            os.system("mv %s/%s.csv %s" % (cDir, self._outputFileName, self._outputFileNameCSV))
            os.system("mv %s/%s.png %s" % (cDir, self._outputFileName, self._outputFileNamePNG))
            os.system("mv %s/%sPerNt.png %s" % (cDir, self._outputFileName, self._outputFileNamePerNtPNG))

        self._cleanWorkingDir(cDir)

if __name__ == '__main__':
    launcher = WrappGetLetterDistribution()
    launcher.setAttributesFromCommandLine()
    launcher.wrapp()

