#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
from commons.core.writer.TranscriptListWriter import TranscriptListWriter


class BedWriter(TranscriptListWriter):
    """
    A class that writes a transcript list into a file with BED format
    @ivar fileName: name of the file 
    @type fileName: string
    @ivar handle:     handle to the file
    @type handle:     file handle
    @ivar header:     first lines of the file
    @type header:     string
    """


    def __init__(self, fileName, verbosity = 0):
        """
        Constructor
        @param fileName:    name of the file 
        @type    fileName:    string
        @param verbosity: verbosity
        @type    verbosity: int
        """
        self.header = "track name=reads description=\"Reads\" useScore=0 visibility=full offset=0\n"
        super(BedWriter, self).__init__(fileName, verbosity)


    @staticmethod
    def getFileFormats():
        """
        Get the format of the file
        """
        return ["bed"]


    @staticmethod
    def getExtension():
        """
        Get the usual extension for the file
        """
        return "bed"
        
        
    def setTitle(self, title):
        """
        Set the title of the track
        @param title: the title of the track
        @type    title: string
        """
        if title != None:
            self.header = "track name=%s description=\"%s\" useScore=0 visibility=full offset=0\n" % (title, title)


    def copyProperties(self, bedParser):
        """
        Copy the properties collected by a parser, to produce a similar output
        @param bedParser: a BED Parser parser
        @type    bedParser: class L{BedParser<BedParser>}
        """
        self.setTitle(bedParser.title)
        

    def printTranscript(self, transcript):
        """
        Export the given transcript with GBrowse format
        @param transcript: transcript to be printed
        @type    transcript: class L{Transcript<Transcript>}
        @return:                     a string
        """
        return transcript.printBed()

