#!/usr/bin/perl

use strict;
use warnings;
use Getopt::Long;

use Bio::Seq::GenomeID qw(generate_id);

my ($outFile, $inFile, $type, $index, $hg);
my ($noise, $baq, $sex, $ucn, $ref, $name);

GetOptions("o=s"=> \$outFile,
				"n=f"=>\$noise,
				"hg=s"=> \$hg,
				"b=i"=> \$baq,
				"s=s"=> \$sex,
				"u=s"=> \$ucn,
				"r=s"=> \$ref,
				"type=s"=> \$type,
				"file=s"=> \$inFile,
				"sN=s"=> \$name,
);
$ucn = ($ucn eq "true")? 1:0; $sex = ($sex eq "true")?1:0; $ref = ($ref eq "true")?1:0;

my %obj;
$obj{'type'} = $type; $obj{'file'} = $inFile;
$obj{'ucn'} = $ucn; $obj{'sex'} = $sex; $obj{'ref'} = $ref;
$obj{'noise'} = $noise; $obj{'baq'} = $baq; 

if($type eq "tbi"){
	`tabix -p vcf $inFile`;
}


if($hg ne "none"){
	$obj{'hg'} = $hg;
}

if( defined $name ){
	$obj{'sampleName'} = $name;
}

my $genomeID = generate_id(%obj);
open(my $fh, '>', $outFile);
print $fh $genomeID;
close $fh;
