import os
import re
import sys
import operator
import csv
from galaxy import config

# get tool-data path
configur =  config.Configuration()
kitDir = configur.resolve_path("tool-data")

# determine if config file exists
if not os.path.exists( kitDir +  "/report_poor_coverage" ):
    kitDir = "/export/achri_galaxy/dbs/CaptureKits/";
else:
    with open(kitDir + "/report_poor_coverage", "r") as tsv:
	     for line in csv.reader(tsv, delimiter="\t"):
		      if line[0] == 'capturekits_directory':
				    kitDir = line[1]

def kit_fileOptions():
    list = os.listdir(kitDir);
    list.sort()
    pattern = re.compile('(.*)$')
    fileOptions = [(s) for s in list if os.path.exists(kitDir + s)]
    ds = [pattern.match(s) for s in fileOptions]
    datasets = [(m.group(1), m.group(1), False) for m in ds if m]
    return datasets

